/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.statement;

import java.util.List;
import manifold.preprocessor.TokenType;
import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.expression.EmptyExpression;
import manifold.preprocessor.expression.Expression;
import manifold.preprocessor.statement.SourceStatement;
import manifold.preprocessor.statement.Statement;

public class IfStatement
extends Statement {
    private final Expression _expr;
    private final List<Statement> _ifBlock;
    private final List<IfStatement> _elifs;
    private final List<Statement> _elseBlock;
    private final int _elseStart;

    public IfStatement(TokenType tokenType, int start, int end, Expression expr, List<Statement> ifBlock, List<IfStatement> elifs, List<Statement> elseBlock, int elseStart) {
        super(tokenType, start, end);
        this._expr = expr;
        this._ifBlock = ifBlock;
        this._elifs = elifs;
        this._elseStart = elseStart;
        this._elseBlock = elseBlock;
    }

    @Override
    public void execute(StringBuilder result, CharSequence source, boolean visible, Definitions definitions) {
        this.preserveMaskedOutSpace(result, source, this.getTokenStart(), this._expr.getEndOffset());
        boolean ifCond = visible && this.evalExpr(definitions);
        for (Statement statement : this._ifBlock) {
            statement.execute(result, source, ifCond, definitions);
        }
        boolean elifPassed = false;
        for (IfStatement elif : this._elifs) {
            boolean elifCond = visible && !elifPassed && !ifCond && elif.evalExpr(definitions);
            elifPassed = elifPassed || elifCond;
            elif.execute(result, source, elifCond, definitions);
        }
        if (this._elseStart >= 0) {
            this.preserveMaskedOutSpace(result, source, this._elseStart, this._elseStart + "#else".length());
        }
        for (Statement stmt : this._elseBlock) {
            stmt.execute(result, source, visible && !ifCond && !elifPassed, definitions);
        }
        int n = this.getTokenEnd() - "#endif".length();
        if (n >= 0 && source.subSequence(n, this.getTokenEnd()).toString().equals("#endif")) {
            this.preserveMaskedOutSpace(result, source, n, this.getTokenEnd());
        }
    }

    @Override
    public void execute(List<SourceStatement> result, boolean visible, Definitions definitions) {
        if (!visible) {
            return;
        }
        boolean ifCond = this.evalExpr(definitions);
        for (Statement stmt : this._ifBlock) {
            stmt.execute(result, ifCond, definitions);
        }
        boolean elifPassed = false;
        for (IfStatement elif : this._elifs) {
            boolean elifCond = !elifPassed && !ifCond && elif.evalExpr(definitions);
            elifPassed = elifPassed || elifCond;
            elif.execute(result, elifCond, definitions);
        }
        for (Statement stmt : this._elseBlock) {
            stmt.execute(result, !ifCond && !elifPassed, definitions);
        }
    }

    @Override
    public boolean hasPreprocessorDirectives() {
        return true;
    }

    private boolean evalExpr(Definitions definitions) {
        return !(this._expr instanceof EmptyExpression) && !this._expr.hasErrors() && this._expr.evaluate(definitions);
    }
}

