/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor;

import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.preprocessor.TokenType;
import manifold.preprocessor.Tokenizer;
import manifold.preprocessor.expression.EmptyExpression;
import manifold.preprocessor.expression.Expression;
import manifold.preprocessor.expression.Identifier;
import manifold.preprocessor.expression.StringLiteral;
import manifold.preprocessor.statement.DefineStatement;
import manifold.preprocessor.statement.EmptyStatement;
import manifold.preprocessor.statement.FileStatement;
import manifold.preprocessor.statement.IfStatement;
import manifold.preprocessor.statement.IssueStatement;
import manifold.preprocessor.statement.SourceStatement;
import manifold.preprocessor.statement.Statement;
import manifold.preprocessor.statement.UndefStatement;
import manifold.rt.api.util.Stack;

public class PreprocessorParser {
    private final Tokenizer _tokenizer;
    private BiConsumer<String, Integer> _issueConsumer;
    private Stack<TokenType> _ifState;

    public PreprocessorParser(CharSequence source, Consumer<Tokenizer> consumer) {
        this(source, 0, source.length(), consumer);
    }

    public PreprocessorParser(CharSequence source, int startOffset, int endOffset, Consumer<Tokenizer> consumer) {
        this._tokenizer = new Tokenizer(source, startOffset, endOffset, consumer);
        this._tokenizer.advance();
        this._ifState = new Stack();
    }

    public FileStatement parseFile() {
        return this.parseFile(null);
    }

    public FileStatement parseFile(BiConsumer<String, Integer> issueConsumer) {
        this._issueConsumer = issueConsumer;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        int pos = this._tokenizer.getTokenStart();
        while (this._tokenizer.getTokenType() != null) {
            statements.add(this.parseStatement());
            if (pos == this._tokenizer.getTokenStart() && this._tokenizer.getTokenType() != null) {
                throw new IllegalStateException();
            }
            pos = this._tokenizer.getTokenStart();
        }
        return new FileStatement(statements, 0, this._tokenizer.getTokenEnd());
    }

    public Statement parseStatement() {
        TokenType tokenType = this._tokenizer.getTokenType();
        if (tokenType == null) {
            return new EmptyStatement(TokenType.Source, this._tokenizer.getTokenStart());
        }
        switch (tokenType) {
            case Whitespace: 
            case LineComment: 
            case BlockComment: 
            case StringLiteral: 
            case TextBlock: 
            case CharLiteral: 
            case Source: {
                SourceStatement stmt = new SourceStatement(tokenType, this._tokenizer.getTokenStart(), this._tokenizer.getTokenEnd());
                this._tokenizer.advance();
                return stmt;
            }
            case Define: {
                return this.parseDefineStatement();
            }
            case Undef: {
                return this.parseUndefStatement();
            }
            case Error: 
            case Warning: {
                return this.parseIssueStatement(tokenType == TokenType.Error);
            }
            case If: {
                return this.parseIfStatement();
            }
            case Elif: {
                if (!this.parseErrantIfState(tokenType)) break;
                return this.parseErrantElif();
            }
            case Else: {
                if (!this.parseErrantIfState(tokenType)) break;
                return this.parseErrantElse();
            }
            case Endif: {
                if (!this.parseErrantIfState(tokenType)) break;
                return this.parseErrantEndif();
            }
        }
        return new EmptyStatement(tokenType, this._tokenizer.getTokenStart());
    }

    private boolean parseErrantIfState(TokenType tokenType) {
        TokenType ifState = this.peekParsingIf();
        return ifState == null || (tokenType == TokenType.Elif ? ifState.ordinal() > tokenType.ordinal() : ifState.ordinal() >= tokenType.ordinal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IfStatement parseIfStatement() {
        this.pushParsingIf(TokenType.If);
        try {
            IfStatement ifStmt;
            int ifStart = this._tokenizer.getTokenStart();
            Expression ifExpr = this._tokenizer.getExpression();
            this._tokenizer.advance();
            this.addErrors(ifExpr);
            ArrayList<Statement> ifBlock = new ArrayList<Statement>();
            Statement stmt = this.parseStatement();
            while (!(stmt instanceof EmptyStatement)) {
                ifBlock.add(stmt);
                stmt = this.parseStatement();
            }
            ArrayList<IfStatement> elifs = this.parseElifs();
            ArrayList<Statement> elseBlock = this.parseElse();
            if (this._tokenizer.getTokenType() == TokenType.Endif) {
                ifStmt = new IfStatement(TokenType.If, ifStart, this._tokenizer.getTokenEnd(), ifExpr, ifBlock, elifs, elseBlock);
                this._tokenizer.advance();
            } else {
                ifStmt = new IfStatement(TokenType.If, ifStart, this._tokenizer.getTokenStart(), ifExpr, ifBlock, elifs, elseBlock);
                this.addError("Expecting '#endif' to close '#if'");
            }
            IfStatement ifStatement = ifStmt;
            return ifStatement;
        }
        finally {
            this.popParsingIf(TokenType.If);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<IfStatement> parseElifs() {
        this.pushParsingIf(TokenType.Elif);
        try {
            ArrayList<IfStatement> elifs = new ArrayList<IfStatement>();
            while (this._tokenizer.getTokenType() == TokenType.Elif) {
                int elifStart = this._tokenizer.getTokenStart();
                int elifEnd = this._tokenizer.getTokenEnd();
                Expression elifExpr = this._tokenizer.getExpression();
                this._tokenizer.advance();
                this.addErrors(elifExpr);
                ArrayList<Statement> elifIfBlock = new ArrayList<Statement>();
                Statement stmt = this.parseStatement();
                while (!(stmt instanceof EmptyStatement)) {
                    elifEnd = stmt.getTokenEnd();
                    elifIfBlock.add(stmt);
                    stmt = this.parseStatement();
                }
                IfStatement elif = new IfStatement(TokenType.Elif, elifStart, elifEnd, elifExpr, elifIfBlock, Collections.emptyList(), Collections.emptyList());
                elifs.add(elif);
            }
            ArrayList<IfStatement> arrayList = elifs;
            return arrayList;
        }
        finally {
            this.popParsingIf(TokenType.Elif);
        }
    }

    private ArrayList<Statement> parseElse() {
        this.pushParsingIf(TokenType.Else);
        try {
            ArrayList<Statement> elseBlock = new ArrayList<Statement>();
            if (this._tokenizer.getTokenType() == TokenType.Else) {
                this._tokenizer.advance();
                Statement stmt = this.parseStatement();
                while (!(stmt instanceof EmptyStatement)) {
                    elseBlock.add(stmt);
                    stmt = this.parseStatement();
                }
            }
            ArrayList<Statement> arrayList = elseBlock;
            return arrayList;
        }
        finally {
            this.popParsingIf(TokenType.Else);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IfStatement parseErrantElif() {
        this.pushParsingIf(TokenType.Elif);
        try {
            IfStatement ifStmt;
            this.addError("'#" + this._tokenizer.getTokenType().getDirective() + "' without '#if'");
            int elifStart = this._tokenizer.getTokenStart();
            Expression elifExpr = this._tokenizer.getExpression();
            this._tokenizer.advance();
            this.addErrors(elifExpr);
            ArrayList<Statement> ifBlock = new ArrayList<Statement>();
            Statement stmt = this.parseStatement();
            while (!(stmt instanceof EmptyStatement)) {
                ifBlock.add(stmt);
                stmt = this.parseStatement();
            }
            ArrayList<IfStatement> elifs = this.parseElifs();
            ArrayList<Statement> elseBlock = this.parseElse();
            if (this._tokenizer.getTokenType() == TokenType.Endif) {
                ifStmt = new IfStatement(TokenType.If, elifStart, this._tokenizer.getTokenEnd(), elifExpr, ifBlock, elifs, elseBlock);
                this._tokenizer.advance();
            } else {
                ifStmt = new IfStatement(TokenType.If, elifStart, this._tokenizer.getTokenStart(), elifExpr, ifBlock, elifs, elseBlock);
                this.addError("Expecting '#endif' to close '#if'");
            }
            IfStatement ifStatement = ifStmt;
            return ifStatement;
        }
        finally {
            this.popParsingIf(TokenType.Elif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IfStatement parseErrantElse() {
        this.pushParsingIf(TokenType.Else);
        try {
            IfStatement ifStmt;
            this.addError("'#" + this._tokenizer.getTokenType().getDirective() + "' without '#if'");
            int elseStart = this._tokenizer.getTokenStart();
            int elseEnd = this._tokenizer.getTokenEnd();
            this._tokenizer.advance();
            ArrayList<Statement> elseBlock = new ArrayList<Statement>();
            Statement stmt = this.parseStatement();
            while (!(stmt instanceof EmptyStatement)) {
                elseBlock.add(stmt);
                stmt = this.parseStatement();
            }
            if (this._tokenizer.getTokenType() == TokenType.Endif) {
                ifStmt = new IfStatement(TokenType.If, elseStart, this._tokenizer.getTokenEnd(), new EmptyExpression(elseEnd), Collections.emptyList(), Collections.emptyList(), elseBlock);
                this._tokenizer.advance();
            } else {
                ifStmt = new IfStatement(TokenType.If, elseStart, this._tokenizer.getTokenStart(), new EmptyExpression(elseEnd), Collections.emptyList(), Collections.emptyList(), elseBlock);
                this.addError("Expecting '#endif' to close '#if'");
            }
            IfStatement ifStatement = ifStmt;
            return ifStatement;
        }
        finally {
            this.popParsingIf(TokenType.Else);
        }
    }

    private IfStatement parseErrantEndif() {
        this.addError("'#" + this._tokenizer.getTokenType().getDirective() + "' without '#if'");
        int endifStart = this._tokenizer.getTokenStart();
        int endifEnd = this._tokenizer.getTokenEnd();
        this._tokenizer.advance();
        return new IfStatement(TokenType.If, endifStart, endifEnd, new EmptyExpression(endifStart), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private DefineStatement parseDefineStatement() {
        String name;
        Expression expr = this._tokenizer.getExpression();
        if (!(expr instanceof Identifier)) {
            name = "";
            this.addError("Expecting a symbol name here");
        } else {
            name = ((Identifier)expr).getName();
        }
        DefineStatement defineStmt = new DefineStatement(this._tokenizer.getTokenStart(), this._tokenizer.getTokenEnd(), name);
        this._tokenizer.advance();
        return defineStmt;
    }

    private UndefStatement parseUndefStatement() {
        String name;
        Expression expr = this._tokenizer.getExpression();
        if (!(expr instanceof Identifier)) {
            name = "";
            this.addError("Expressions not allowed here");
        } else {
            name = ((Identifier)expr).getName();
        }
        UndefStatement defineStmt = new UndefStatement(this._tokenizer.getTokenStart(), this._tokenizer.getTokenEnd(), name);
        this._tokenizer.advance();
        return defineStmt;
    }

    private IssueStatement parseIssueStatement(boolean isError) {
        StringLiteral messageExpr;
        Expression expr = this._tokenizer.getExpression();
        if (!(expr instanceof StringLiteral)) {
            messageExpr = null;
            this.addError("Expecting a quoted messageExpr", expr.getStartOffset());
        } else {
            messageExpr = (StringLiteral)expr;
        }
        IssueStatement issueStatement = new IssueStatement(this._tokenizer.getTokenStart(), this._tokenizer.getTokenEnd(), messageExpr, isError);
        this._tokenizer.advance();
        return issueStatement;
    }

    private void addError(String message) {
        this.addError(message, this._tokenizer.getTokenStart());
    }

    private void addError(String message, int pos) {
        if (this._issueConsumer != null) {
            this._issueConsumer.accept(message, pos);
        }
        if (JavacPlugin.instance() == null) {
            return;
        }
        IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), (JCDiagnostic.DiagnosticPosition)new JCDiagnostic.SimpleDiagnosticPosition(pos), "proc.messager", new Object[]{message});
    }

    private void addErrors(Expression expression) {
        expression.visitErrors(e -> {
            this.addError(e.getMessage(), e.getPosition());
            return true;
        });
    }

    private void pushParsingIf(TokenType ifType) {
        switch (ifType) {
            case If: 
            case Elif: 
            case Else: {
                this._ifState.push((Object)ifType);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)ifType) + " is not a component of '#if'");
            }
        }
    }

    private TokenType popParsingIf(TokenType ifType) {
        switch (ifType) {
            case If: 
            case Elif: 
            case Else: {
                if (ifType != this._ifState.peek()) {
                    throw new IllegalStateException("Unbalanced stack. Found " + this._ifState.peek() + " but expected " + (Object)((Object)ifType));
                }
                return (TokenType)((Object)this._ifState.pop());
            }
        }
        throw new IllegalArgumentException((Object)((Object)ifType) + " is not a component of '#if'");
    }

    private TokenType peekParsingIf() {
        return this._ifState.isEmpty() ? null : (TokenType)((Object)this._ifState.peek());
    }
}

