/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.statement;

import java.util.List;
import manifold.preprocessor.TokenType;
import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.statement.Statement;

public class SourceStatement
extends Statement {
    public SourceStatement(TokenType tokenType, int start, int end) {
        super(tokenType, start, end);
    }

    @Override
    public void execute(StringBuilder result, CharSequence source, boolean visible, Definitions definitions) {
        if (visible) {
            result.append(source.subSequence(this.getTokenStart(), this.getTokenEnd()));
        } else if (this.getTokenType() == TokenType.Whitespace || this.getTokenType() == TokenType.BlockComment || this.getTokenType() == TokenType.LineComment || this.getTokenType() == TokenType.TextBlock) {
            this.preserveNewLines(result, source);
        }
    }

    private void preserveNewLines(StringBuilder result, CharSequence source) {
        for (int i = this.getTokenStart(); i < this.getTokenEnd(); ++i) {
            char c = source.charAt(i);
            if (c != '\r' && c != '\n' && c != '\f') continue;
            result.append(c);
        }
    }

    @Override
    public void execute(List<SourceStatement> result, boolean visible, Definitions definitions) {
        if (visible) {
            result.add(this);
        }
    }

    @Override
    public boolean hasPreprocessorDirectives() {
        return false;
    }
}

