/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.android.syms;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.internal.javac.JavacPlugin;
import manifold.preprocessor.api.SymbolProvider;
import manifold.preprocessor.definitions.Definitions;
import manifold.rt.api.util.StreamUtil;
import manifold.util.JreUtil;
import manifold.util.ManExceptionUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class BuildVariantSymbols
implements SymbolProvider {
    private final LocklessLazyVar<Map<String, String>> _buildConfigSyms = LocklessLazyVar.make(() -> this.loadBuildConfigSymbols());

    public boolean isDefined(Definitions rootDefinitions, IFile sourceFile, String def) {
        return ((Map)this._buildConfigSyms.get()).containsKey(def);
    }

    public String getValue(Definitions rootDefinitions, IFile sourceFile, String def) {
        return (String)((Map)this._buildConfigSyms.get()).get(def);
    }

    private Map<String, String> loadBuildConfigSymbols() {
        String generatedClassesDir = this.getBuildConfigSourcePath();
        if (generatedClassesDir == null) {
            return Collections.emptyMap();
        }
        File dir = new File(generatedClassesDir);
        File buildConfig = this.findBuildConfig(dir);
        if (buildConfig != null) {
            return this.extractBuildConfigSymbols(buildConfig);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> extractBuildConfigSymbols(File buildConfig) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            List<JCTree> defs;
            Tree cls;
            CompilationUnitTree tree;
            java.util.List<? extends Tree> typeDecls;
            FileReader fileReader = new FileReader(buildConfig);
            ArrayList trees = new ArrayList();
            JavacPlugin.instance().getHost().getJavaParser().parseText(StreamUtil.getContent((Reader)fileReader), trees, null, null, null);
            if (!trees.isEmpty() && (typeDecls = (tree = (CompilationUnitTree)trees.get(0)).getTypeDecls()) != null && !typeDecls.isEmpty() && (cls = typeDecls.get(0)) instanceof JCTree.JCClassDecl && !(defs = ((JCTree.JCClassDecl)cls).defs).isEmpty()) {
                for (JCTree def : defs) {
                    if (!(def instanceof JCTree.JCVariableDecl)) continue;
                    this.processConstant(map, (JCTree.JCVariableDecl)def);
                }
            }
        }
        catch (IOException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
        return map;
    }

    private void processConstant(Map<String, String> map, JCTree.JCVariableDecl def) {
        JCTree.JCExpression initializer;
        int psf;
        JCTree.JCModifiers modifiers = def.getModifiers();
        long mods = modifiers == null ? 0L : modifiers.flags;
        if ((mods & (long)(psf = 25)) == (long)psf && (initializer = def.getInitializer()) != null) {
            String value;
            block8: {
                value = null;
                String init = initializer.toString();
                if (init.startsWith("\"")) {
                    value = init.substring(1, init.length() - 1);
                } else {
                    try {
                        long l = Long.parseLong(init);
                        value = init;
                    }
                    catch (Exception e) {
                        try {
                            double d = Double.parseDouble(init);
                            value = init;
                        }
                        catch (Exception e2) {
                            if (!init.contains("true")) break block8;
                            value = "";
                        }
                    }
                }
            }
            if (value != null) {
                map.put(def.getName().toString(), value);
            }
        }
    }

    private String getBuildConfigSourcePath() {
        Set sourcePath = JavacPlugin.instance().deriveJavaSourcePath();
        String generatedClassesDir = null;
        for (String path : sourcePath) {
            int index = path.lastIndexOf("/app/src/".replace('/', File.separatorChar));
            if (index <= 0) continue;
            generatedClassesDir = path.substring(0, index) + "/app/build/generated/source/buildConfig".replace('/', File.separatorChar);
            String variantPart = this.getVariantPart();
            if (variantPart == null) break;
            generatedClassesDir = generatedClassesDir + File.separatorChar + variantPart;
            break;
        }
        return generatedClassesDir;
    }

    private String getVariantPart() {
        try {
            String[] args;
            String variantPart = null;
            if (JreUtil.isJava8()) {
                args = (String[])ReflectUtil.field((Object)JavacPlugin.instance().getJavacTask(), (String)"args").get();
                boolean found = false;
                for (String arg : args) {
                    if (arg != null && arg.equalsIgnoreCase("-s")) {
                        found = true;
                        continue;
                    }
                    if (!found) continue;
                    variantPart = arg;
                    break;
                }
            } else {
                args = ReflectUtil.field((Object)JavacPlugin.instance().getJavacTask(), (String)"args").get();
                Object options = ReflectUtil.field((Object)args, (String)"options").get();
                variantPart = (String)ReflectUtil.method((Object)options, (String)"get", (Class[])new Class[]{String.class}).invoke(new Object[]{"-s"});
            }
            if (variantPart == null) {
                return null;
            }
            String marker = File.separatorChar + "ap_generated_sources" + File.separatorChar;
            int index = variantPart.lastIndexOf(marker);
            if (index > 0) {
                variantPart = variantPart.substring(index + marker.length());
                int outIndex = variantPart.lastIndexOf(File.separatorChar);
                variantPart = variantPart.substring(0, outIndex);
                return variantPart;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File findBuildConfig(File file) {
        if (file.isFile()) {
            if (file.getName().equals("BuildConfig.java")) {
                return file;
            }
            return null;
        }
        File[] listing = file.listFiles();
        if (listing != null) {
            for (File f : listing) {
                File buildConfig = this.findBuildConfig(f);
                if (buildConfig == null) continue;
                return buildConfig;
            }
        }
        return null;
    }
}

