/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.xml.parser;

import java.io.InputStream;
import java.util.Stack;
import manifold.api.util.Pair;
import manifold.api.xml.parser.XmlAttribute;
import manifold.api.xml.parser.XmlElement;
import manifold.api.xml.parser.XmlRootElement;
import manifold.api.xml.parser.XmlTerminal;
import manifold.api.xml.parser.antlr.XMLParser;
import manifold.api.xml.parser.antlr.XMLParserBaseListener;
import manifold.api.xml.parser.antlr.gen.XMLLexer;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

public class XmlParser {
    private XmlElement _root = null;

    public static XmlElement parse(InputStream inputStream) {
        return new XmlParser((InputStream)inputStream)._root;
    }

    public static XMLParser.DocumentContext parseRaw(InputStream inputStream) {
        try {
            XMLLexer lexer = new XMLLexer(CharStreams.fromStream((InputStream)inputStream));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            XMLParser parser = new XMLParser((TokenStream)tokens);
            return parser.document();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XmlParser(InputStream inputStream) {
        try {
            XMLParser.DocumentContext ctx = XmlParser.parseRaw(inputStream);
            ParseTreeWalker walker = new ParseTreeWalker();
            XmlBuilder builder = new XmlBuilder();
            walker.walk((ParseTreeListener)builder, (ParseTree)ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class XmlBuilder
    extends XMLParserBaseListener {
        private XmlElement _prolog;
        private Stack<Pair<ParserRuleContext, XmlElement>> _elements = new Stack();
        private XmlAttribute _attribute;

        private XmlBuilder() {
        }

        @Override
        public void enterProlog(XMLParser.PrologContext ctx) {
            this._prolog = new XmlElement(ctx, null);
            this._elements.push((Pair<ParserRuleContext, XmlElement>)new Pair((Object)ctx, (Object)this._prolog));
        }

        @Override
        public void exitProlog(XMLParser.PrologContext ctx) {
            this._elements.pop();
        }

        @Override
        public void enterElement(XMLParser.ElementContext ctx) {
            XmlElement xmlElement;
            XmlElement parent;
            XmlElement xmlElement2 = parent = this._elements.isEmpty() ? null : (XmlElement)this._elements.peek().getSecond();
            if (parent == null) {
                xmlElement = new XmlRootElement(ctx, this._prolog);
                this._prolog = null;
            } else {
                xmlElement = new XmlElement(ctx, parent);
                parent.addChild(xmlElement);
            }
            this._elements.push((Pair<ParserRuleContext, XmlElement>)new Pair((Object)ctx, (Object)xmlElement));
            if (XmlParser.this._root == null) {
                XmlParser.this._root = xmlElement;
            }
        }

        @Override
        public void exitElement(XMLParser.ElementContext ctx) {
            Pair<ParserRuleContext, XmlElement> popped = this._elements.pop();
            if (popped.getFirst() != ctx) {
                throw new IllegalStateException("Unbalanced elements, expecting '" + ctx.Name(0) + "' but found '" + popped.getFirst() + "'");
            }
        }

        @Override
        public void enterAttribute(XMLParser.AttributeContext ctx) {
            if (this._attribute != null) {
                throw new IllegalStateException("Error processing attribute '" + ctx.Name().getText() + "', there is already an attribute processing: '" + this._attribute.getName().getRawText());
            }
            XmlElement parent = (XmlElement)this._elements.peek().getSecond();
            this._attribute = new XmlAttribute(ctx, parent);
            parent.addAttribute(this._attribute);
        }

        @Override
        public void exitAttribute(XMLParser.AttributeContext ctx) {
            if (this._attribute == null) {
                throw new IllegalStateException("Expecting non-null attribute during exitAttribute()");
            }
            this._attribute = null;
        }

        @Override
        public void visitTerminal(TerminalNode node) {
            Token symbol = node.getSymbol();
            if (this._attribute != null) {
                if (symbol.getType() == 15) {
                    this._attribute.setRawValue(new XmlTerminal(symbol, this._attribute));
                }
            } else if (!(this._elements.isEmpty() || symbol.getType() != 9 && symbol.getType() != 15 && symbol.getType() != 2)) {
                XmlElement second = (XmlElement)this._elements.peek().getSecond();
                second.setRawContent(new XmlTerminal(symbol, second));
            }
        }
    }
}

