/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.csv.parser;

import manifold.api.csv.parser.CsvToken;

class DataStats {
    private static final int THRESHOLD_PERCENTAGE = 75;
    private int _alpha;
    private int _digit;
    private int _white;
    private int _other;
    private int _total;

    DataStats(CsvToken token) {
        String data = token.getData();
        this._total = data.length();
        if (this._total == 0) {
            return;
        }
        for (int i = 0; i < this._total; ++i) {
            char c = data.charAt(i);
            if (Character.isAlphabetic(c)) {
                ++this._alpha;
                continue;
            }
            if (Character.isDigit(c)) {
                ++this._digit;
                continue;
            }
            if (Character.isWhitespace(c)) {
                ++this._white;
                continue;
            }
            ++this._other;
        }
        this._alpha = this._alpha * 100 / this._total;
        this._digit = this._digit * 100 / this._total;
        this._white = this._white * 100 / this._total;
        this._other = this._other * 100 / this._total;
    }

    boolean isSimilar(CsvToken token) {
        DataStats data = new DataStats(token);
        return this.isSimilar(this._alpha, data._alpha) && this.isSimilar(this._digit, data._digit) && this.isSimilar(this._white, data._white) && this.isSimilar(this._other, data._other) && this.isSimilar(this._total, data._total);
    }

    private boolean isSimilar(int d1, int d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == 0 || d2 == 0) {
            return false;
        }
        int max = d1 > d2 ? d1 : d2;
        int min = d1 < d2 ? d1 : d2;
        return 100 - (max - min) * 100 / max >= 75;
    }
}

