/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.csv.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import manifold.api.csv.parser.CsvDataSet;
import manifold.api.csv.parser.CsvField;
import manifold.api.csv.parser.CsvHeader;
import manifold.api.csv.parser.CsvRecord;
import manifold.api.csv.parser.CsvToken;
import manifold.api.csv.parser.CsvTokenizer;
import manifold.api.util.StreamUtil;

public class CsvParser {
    private final CsvTokenizer _tokenizer;

    public static CsvDataSet parse(InputStream inputStream) {
        return new CsvParser(inputStream).parse();
    }

    private CsvParser(InputStream inputStream) {
        try {
            String content = StreamUtil.getContent((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            this._tokenizer = new CsvTokenizer(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CsvDataSet parse() {
        return new CsvDataSet(this.parseHeader(), this.parseRecords(), this._tokenizer.getTypes());
    }

    private List<CsvRecord> parseRecords() {
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        ArrayList<CsvField> fields = new ArrayList<CsvField>();
        while (true) {
            CsvToken token = this._tokenizer.nextToken();
            fields.add(new CsvField(token));
            if (!token.isLastInRecord()) continue;
            records.add(new CsvRecord(fields));
            if (token.isEof()) break;
            fields = new ArrayList();
        }
        return records;
    }

    private CsvHeader parseHeader() {
        if (this._tokenizer.hasHeader()) {
            CsvToken token;
            ArrayList<CsvField> fields = new ArrayList<CsvField>();
            do {
                token = this._tokenizer.nextToken();
                fields.add(new CsvField(token));
            } while (!token.isLastInRecord());
            return new CsvHeader(fields);
        }
        return null;
    }
}

