/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.parser;

import java.io.IOException;
import java.io.Reader;
import manifold.api.json.parser.Token;
import manifold.api.json.parser.TokenType;

final class Tokenizer {
    private Reader _source;
    private char _ch;
    private int _line;
    private int _column;
    private int _offset;

    Tokenizer(Reader source) {
        this._source = source;
        this._offset = 0;
        this._line = 1;
        this._column = 0;
        this.nextChar();
    }

    Token next() {
        Token T;
        this.eatWhiteSpace();
        switch (this._ch) {
            case '\"': 
            case '\'': {
                T = this.consumeString(this._ch);
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                T = this.consumeNumber();
                break;
            }
            case '{': {
                T = new Token(TokenType.LCURLY, "{", this._offset, this._line, this._column);
                this.nextChar();
                break;
            }
            case '}': {
                T = new Token(TokenType.RCURLY, "}", this._offset, this._line, this._column);
                this.nextChar();
                break;
            }
            case '[': {
                T = new Token(TokenType.LSQUARE, "[", this._offset, this._line, this._column);
                this.nextChar();
                break;
            }
            case ']': {
                T = new Token(TokenType.RSQUARE, "]", this._offset, this._line, this._column);
                this.nextChar();
                break;
            }
            case ',': {
                T = new Token(TokenType.COMMA, ",", this._offset, this._line, this._column);
                this.nextChar();
                break;
            }
            case ':': {
                T = new Token(TokenType.COLON, ":", this._offset, this._line, this._column);
                this.nextChar();
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                T = this.consumeConstant();
                break;
            }
            case '\u0000': {
                T = new Token(TokenType.EOF, "EOF", this._offset, this._line, this._column);
                break;
            }
            default: {
                T = new Token(TokenType.ERROR, String.valueOf(this._ch), this._offset, this._line, this._column);
                this.nextChar();
            }
        }
        return T;
    }

    private Token consumeString(char quote) {
        StringBuilder sb = new StringBuilder();
        int line = this._line;
        int column = this._column;
        int offset = this._offset;
        this.nextChar();
        block9: while (this.moreChars() && this._ch != quote) {
            if (this._ch == '\\') {
                this.nextChar();
                switch (this._ch) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append(this._ch);
                        this.nextChar();
                        continue block9;
                    }
                    case 'b': {
                        sb.append('\b');
                        this.nextChar();
                        continue block9;
                    }
                    case 'f': {
                        sb.append('\f');
                        this.nextChar();
                        continue block9;
                    }
                    case 'n': {
                        sb.append('\n');
                        this.nextChar();
                        continue block9;
                    }
                    case 'r': {
                        sb.append('\r');
                        this.nextChar();
                        continue block9;
                    }
                    case 't': {
                        sb.append('\t');
                        this.nextChar();
                        continue block9;
                    }
                    case 'u': {
                        this.nextChar();
                        int u = 0;
                        for (int i = 0; i < 4; ++i) {
                            if (this.isHexDigit(this._ch)) {
                                u = u * 16 + this._ch - 48;
                                if (this._ch >= 'A') {
                                    u -= 7;
                                }
                            } else {
                                Token T = new Token(TokenType.ERROR, sb.toString(), this._offset, this._line, this._column);
                                this.nextChar();
                                return T;
                            }
                            this.nextChar();
                        }
                        sb.append((char)u);
                        continue block9;
                    }
                }
                Token T = new Token(TokenType.ERROR, sb.toString(), this._offset, this._line, this._column);
                this.nextChar();
                return T;
            }
            sb.append(this._ch);
            this.nextChar();
        }
        Token T = this._ch == quote ? new Token(TokenType.STRING, sb.toString(), offset, line, column) : new Token(TokenType.ERROR, sb.toString(), this._offset, this._line, this._column);
        this.nextChar();
        return T;
    }

    private Token consumeNumber() {
        boolean err;
        StringBuilder sb = new StringBuilder();
        int line = this._line;
        int column = this._column;
        int offset = this._offset;
        boolean isDouble = false;
        if (this._ch == '-') {
            sb.append(this._ch);
            this.nextChar();
        }
        if (this._ch != '0') {
            err = this.consumeDigits(sb);
            if (err) {
                return new Token(TokenType.ERROR, sb.toString(), this._offset, this._line, this._column);
            }
        } else {
            sb.append(this._ch);
            this.nextChar();
        }
        if (this._ch == '.') {
            isDouble = true;
            sb.append(this._ch);
            this.nextChar();
            err = this.consumeDigits(sb);
            if (err) {
                return new Token(TokenType.ERROR, sb.toString(), this._offset, this._line, this._column);
            }
        }
        if (this._ch == 'E' || this._ch == 'e') {
            isDouble = true;
            sb.append(this._ch);
            this.nextChar();
            if (this._ch == '-') {
                sb.append(this._ch);
                this.nextChar();
            } else if (this._ch == '+') {
                sb.append(this._ch);
                this.nextChar();
            }
            err = this.consumeDigits(sb);
            if (err) {
                return new Token(TokenType.ERROR, sb.toString(), this._offset, this._line, this._column);
            }
        }
        Token T = isDouble ? new Token(TokenType.DOUBLE, sb.toString(), offset, line, column) : new Token(TokenType.INTEGER, sb.toString(), offset, line, column);
        return T;
    }

    private boolean consumeDigits(StringBuilder sb) {
        boolean err = false;
        if (this.isDigit(this._ch)) {
            while (this.moreChars() && this.isDigit(this._ch)) {
                sb.append(this._ch);
                this.nextChar();
            }
        } else {
            err = true;
        }
        return err;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private Token consumeConstant() {
        StringBuilder sb = new StringBuilder();
        int l = this._line;
        int c = this._column;
        do {
            sb.append(this._ch);
            this.nextChar();
        } while (this.moreChars() && (this._ch >= 'a' && this._ch <= 'z' || this._ch >= 'A' && this._ch <= 'Z'));
        String str = sb.toString();
        TokenType type = Token.Constants.get(str);
        Token T = type == null ? new Token(TokenType.ERROR, str, this._offset, l, c) : new Token(type, str, this._offset, l, c);
        return T;
    }

    private void eatWhiteSpace() {
        while (this.moreChars() && (this._ch == '\t' || this._ch == '\n' || this._ch == '\r' || this._ch == ' ')) {
            this.nextChar();
        }
    }

    private void nextChar() {
        int c;
        try {
            c = this._source.read();
            ++this._offset;
        }
        catch (IOException e) {
            c = -1;
        }
        if (c == 10) {
            this._column = 0;
            ++this._line;
        } else if (c != -1) {
            ++this._column;
        } else {
            c = 0;
        }
        this._ch = (char)c;
    }

    private boolean moreChars() {
        return this._ch != '\u0000';
    }
}

