/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.json.AbstractJsonTypeManifold;
import manifold.api.json.IJsonList;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonBasicType;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonEnumType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.api.type.TypeReference;
import manifold.api.util.JsonUtil;
import manifold.api.util.ManClassUtil;
import manifold.api.util.ManEscapeUtil;
import manifold.api.util.ManStringUtil;

public abstract class JsonSchemaType
implements IJsonParentType,
Cloneable {
    protected static final String FIELD_FILE_URL = "__FILE_URL_";
    private final State _state;
    private TypeAttributes _typeAttributes;
    private AbstractJsonTypeManifold _tm;

    protected JsonSchemaType(String name, IFile source, JsonSchemaType parent, TypeAttributes attr) {
        this._state = new State(name, parent, source);
        this._typeAttributes = attr;
    }

    public String getFqn() {
        String result = "";
        if (!this.isParentRoot()) {
            result = this.getParent().getFqn();
            result = result + '.';
        }
        return result + JsonUtil.makeIdentifier((String)this.getLabel());
    }

    protected AbstractJsonTypeManifold getTm() {
        if (this._tm == null && this.getParent() != null) {
            return this.getParent().getTm();
        }
        return this._tm;
    }

    public void setTm(AbstractJsonTypeManifold tm) {
        this._tm = tm;
    }

    public final void resolveRefs() {
        if (this._state._resolveState != ResolveState.Unresolved) {
            return;
        }
        this._state._resolveState = ResolveState.Resolving;
        try {
            this.resolveRefsImpl();
        }
        finally {
            this._state._resolveState = ResolveState.Resolved;
        }
    }

    protected void resolveRefsImpl() {
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null && !definitions.isEmpty()) {
            ArrayList<IJsonType> resolved = new ArrayList<IJsonType>();
            for (IJsonType type : definitions) {
                if (type instanceof JsonSchemaType) {
                    ((JsonSchemaType)type).resolveRefs();
                } else if (type instanceof LazyRefJsonType) {
                    type = ((LazyRefJsonType)type).resolve();
                }
                resolved.add(type);
            }
            this._state._definitions = resolved;
        }
    }

    protected boolean isParentRoot() {
        return this.getParent() == null || this.getParent().getParent() == null && !this.getParent().getName().equals("definitions");
    }

    public IFile getFile() {
        return this._state._file != null ? this._state._file : (this._state._parent != null ? this._state._parent.getFile() : null);
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this._state._name;
    }

    @Override
    public String getIdentifier() {
        return JsonUtil.makeIdentifier((String)this.getName());
    }

    public Token getToken() {
        return this._state._token;
    }

    public void setToken(Token token) {
        this._state._token = token;
    }

    @Override
    public JsonSchemaType getParent() {
        return this._state._parent;
    }

    public void setParent(IJsonParentType parent) {
        this._state._parent = (JsonSchemaType)parent;
    }

    @Override
    public List<IJsonType> getDefinitions() {
        return this._state._definitions;
    }

    @Override
    public void setDefinitions(List<IJsonType> definitions) {
        this._state._definitions = definitions;
    }

    protected boolean isSchemaType() {
        return this._state._bSchemaType;
    }

    protected void setJsonSchema() {
        this._state._bSchemaType = true;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public JsonSchemaType copyWithAttributes(TypeAttributes attributes) {
        if (this.getTypeAttributes().equals(attributes)) {
            return this;
        }
        try {
            JsonSchemaType copy = (JsonSchemaType)this.clone();
            copy._typeAttributes = copy._typeAttributes.overrideWith(attributes);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean mergeInnerTypes(IJsonParentType other, IJsonParentType mergedType, Map<String, IJsonParentType> innerTypes) {
        for (Map.Entry<String, IJsonParentType> e : innerTypes.entrySet()) {
            String name = e.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(e.getValue(), innerType) : (IJsonType)e.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<JsonIssue> getIssues() {
        if (this.getParent() != null) {
            return this.getParent().getIssues();
        }
        return this._state._issues;
    }

    @Override
    public void addIssue(JsonIssue issue) {
        if (this.getParent() != null) {
            this.getParent().addIssue(issue);
            return;
        }
        if (this._state._issues.isEmpty()) {
            this._state._issues = new ArrayList();
        }
        this._state._issues.add(issue);
    }

    protected void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    protected void addTypeReferenceAnnotation(StringBuilder sb, int indent, JsonSchemaType type) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(TypeReference.class.getName()).addArgument("value", String.class, (Object)this.getPropertyType(type, false, true));
        annotation.render(sb, indent);
    }

    protected boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name, Token token) {
        int offset = token.getOffset();
        IFile file = this.getIFile();
        if (file instanceof IFileFragment) {
            offset += ((IFileFragment)file).getOffset();
        }
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this.getIdentifier(), FIELD_FILE_URL})).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)offset).addArgument("length", Integer.TYPE, (Object)name.length());
        annotation.render(sb, indent);
        return true;
    }

    protected IFile getIFile() {
        return this.getFile();
    }

    protected String addActualNameAnnotation(StringBuilder sb, int indent, String name, boolean capitalize) {
        String identifier = this.makeIdentifier(name, capitalize);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    protected String makeMemberIdentifier(IJsonType type) {
        return this.makeIdentifier(type.getName(), false);
    }

    protected String makeIdentifier(String name, boolean capitalize) {
        return capitalize ? ManStringUtil.capitalize((String)JsonUtil.makeIdentifier((String)name)) : JsonUtil.makeIdentifier((String)name);
    }

    protected void renderFileField(StringBuilder sb, int indent) {
        this.renderFileField(sb, indent, null);
    }

    protected void renderFileField(StringBuilder sb, int indent, String modifiers) {
        this.indent(sb, indent);
        try {
            String url = this.getFile() == null ? "null" : this.getFile().toURI().toURL().toString();
            url = ManEscapeUtil.escapeForJavaStringLiteral((String)url);
            sb.append(modifiers == null ? "" : modifiers + " ").append("String ").append(FIELD_FILE_URL).append(" = \"").append(url).append("\";\n");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getPropertyType(IJsonType propertyType) {
        return this.getPropertyType(propertyType, false, false);
    }

    protected String getPropertyType(IJsonType propertyType, boolean qualifiedWithMe, boolean param) {
        String name;
        if (propertyType instanceof JsonListType) {
            if (param) {
                String componentTypeName = this.makeTypeParameter(((JsonListType)propertyType).getComponentType(), qualifiedWithMe, param);
                name = List.class.getTypeName() + '<' + componentTypeName + '>';
            } else {
                name = this.getNameRelativeFromMe(propertyType, qualifiedWithMe);
            }
        } else {
            JsonEnumType enumType;
            name = propertyType instanceof JsonUnionType ? ((enumType = ((JsonUnionType)propertyType).getCollapsedEnumType()) != null ? this.getNameRelativeFromMe(enumType, qualifiedWithMe) : Object.class.getSimpleName()) : (propertyType instanceof JsonSchemaType ? this.getNameRelativeFromMe(propertyType, qualifiedWithMe) : propertyType.getIdentifier());
        }
        return name;
    }

    protected String makeTypeParameter(IJsonType type, boolean qualifiedWithMe, boolean param) {
        if (type instanceof JsonBasicType && ((JsonBasicType)type).isPrimitive()) {
            return ((JsonBasicType)type).box().getTypeName();
        }
        return this.getPropertyType(type, qualifiedWithMe, param);
    }

    protected IJsonType getConstituentQnComponent(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return this.getConstituentQnComponent(((JsonListType)constituentType).getComponentType());
        }
        return constituentType;
    }

    private String getNameRelativeFromMe(IJsonType type, boolean qualifiedWithMe) {
        if (type instanceof JsonSchemaType && !Objects.equals(this.getPackage((JsonSchemaType)type), this.getPackage(this))) {
            return this.getFqn((JsonSchemaType)type);
        }
        IJsonType parent = this.getParentFromMe(type, qualifiedWithMe);
        if (parent == null) {
            return type.getIdentifier();
        }
        return this.getNameRelativeFromMe(parent, qualifiedWithMe) + '.' + type.getIdentifier();
    }

    protected String getFqn(JsonSchemaType type) {
        if (type.getParent() == null) {
            return this.getPackage(type) + '.' + type.getIdentifier();
        }
        return this.getFqn() + '.' + this.getIdentifier();
    }

    private String getPackage(JsonSchemaType type) {
        if (type.getParent() != null) {
            return this.getPackage(type.getParent());
        }
        IFile file = type.getFile();
        String[] types = this.getTm().getTypesForFile(file);
        String fqn = Arrays.stream(types).filter(e -> e.endsWith(type.getIdentifier())).findFirst().orElse(null);
        return ManClassUtil.getPackage((String)fqn);
    }

    private IJsonType getParentFromMe(IJsonType type, boolean qualifiedWithMe) {
        IJsonParentType parent = type.getParent();
        if (parent != null) {
            if (parent.getIdentifier().equals("definitions")) {
                return this.getParentFromMe(parent, qualifiedWithMe);
            }
            if (parent == this) {
                return qualifiedWithMe ? this : null;
            }
        }
        return parent;
    }

    protected String getConstituentQn(IJsonType constituentType, IJsonType propertyType) {
        return this.getConstituentQn(constituentType, propertyType, false);
    }

    protected String getConstituentQn(IJsonType constituentType, IJsonType propertyType, boolean param) {
        String qn;
        if (!(propertyType instanceof JsonListType)) {
            qn = this.getPropertyType(constituentType, false, param);
        } else {
            qn = this.makeTypeParameter(constituentType, false, param);
            while (propertyType instanceof JsonListType) {
                qn = (param ? List.class.getTypeName() : IJsonList.class.getTypeName()) + '<' + qn + '>';
                propertyType = ((JsonListType)propertyType).getComponentType();
            }
        }
        return qn;
    }

    protected boolean isCollapsedUnionEnum(IJsonType type) {
        while (type instanceof JsonListType) {
            type = ((JsonListType)type).getComponentType();
        }
        JsonEnumType enumType = type instanceof JsonUnionType ? ((JsonUnionType)type).getCollapsedEnumType() : null;
        return enumType != null;
    }

    protected String removeGenerics(String specificPropertyType) {
        String rawSpecificPropertyType = specificPropertyType;
        int iAngle = specificPropertyType.indexOf("<");
        if (iAngle > 0 && (rawSpecificPropertyType = rawSpecificPropertyType.substring(0, iAngle)).contains(IJsonList.class.getSimpleName())) {
            rawSpecificPropertyType = List.class.getSimpleName();
        }
        return rawSpecificPropertyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaType that = (JsonSchemaType)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static enum ResolveState {
        Unresolved,
        Resolving,
        Resolved;

    }

    private static class State {
        private final String _name;
        private JsonSchemaType _parent;
        private final IFile _file;
        private List<IJsonType> _definitions;
        private List<JsonIssue> _issues;
        private boolean _bSchemaType;
        private ResolveState _resolveState;
        private Token _token;

        private State(String name, JsonSchemaType parent, IFile file) {
            this._name = name;
            this._parent = parent;
            this._file = file;
            this._issues = Collections.emptyList();
            this._resolveState = ResolveState.Unresolved;
        }
    }
}

