/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.io.IOException;
import javax.script.Bindings;
import manifold.api.json.Yaml;
import manifold.util.JsonUtil;

public class Writer {
    private final Object _value;

    public Writer(Bindings jsonBindings) {
        this._value = jsonBindings;
    }

    public Writer(Iterable<?> jsonList) {
        this._value = jsonList;
    }

    public Writer(Object jsonValue) {
        this._value = jsonValue;
    }

    public String toJson() {
        return JsonUtil.toJson((Object)this._value);
    }

    public void toJson(Appendable target) {
        try {
            target.append(JsonUtil.toJson((Object)this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        StringBuilder sb = new StringBuilder();
        Yaml.toYaml(this._value, sb);
        return sb.toString();
    }

    public void toYaml(Appendable target) {
        try {
            target.append(this.toYaml());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml() {
        return JsonUtil.toXml((Object)this._value);
    }

    public void toXml(Appendable target) {
        try {
            target.append(JsonUtil.toXml((Object)this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml(String name) {
        StringBuilder sb = new StringBuilder();
        JsonUtil.toXml((Object)this._value, (String)name, (StringBuilder)sb, (int)0);
        return sb.toString();
    }
}

