/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.Map;
import javax.script.Bindings;
import manifold.api.json.ErrantType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.api.json.schema.JsonSchemaType;
import manifold.ext.DataBindings;
import manifold.internal.javac.IIssue;
import manifold.util.DebugLogUtil;
import manifold.util.Pair;

class ObjectTransformer {
    private final JsonSchemaTransformer _schemaTx;
    private final JsonStructureType _type;
    private final Bindings _jsonObj;

    static void transform(JsonSchemaTransformer schemaTx, JsonStructureType type, Bindings jsonObj) {
        new ObjectTransformer(schemaTx, type, jsonObj).transform();
    }

    private ObjectTransformer(JsonSchemaTransformer schemaTx, JsonStructureType type, Bindings jsonObj) {
        this._schemaTx = schemaTx;
        this._jsonObj = jsonObj;
        this._type = type;
    }

    JsonStructureType getType() {
        return this._type;
    }

    private void transform() {
        JsonSchemaType parent = this._type.getParent();
        if (parent != null) {
            parent.addChild(this._type.getLabel(), this._type);
        }
        this._schemaTx.cacheByFqn(this._type);
        this.addProperties();
    }

    private void addProperties() {
        Object props = this._jsonObj.get("properties");
        if (props == null) {
            return;
        }
        Token token = null;
        try {
            Bindings properties = props instanceof Pair ? (Bindings)((Pair)props).getSecond() : (Bindings)props;
            for (Map.Entry entry : properties.entrySet()) {
                IJsonType type;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Pair) {
                    token = ((Token[])((Pair)value).getFirst())[0];
                    value = ((Pair)value).getSecond();
                } else {
                    token = null;
                }
                Bindings bindings = this.handleOpenApiIdiom(value);
                if (bindings == null) {
                    ErrantType errant = new ErrantType(null, name);
                    this._type.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Missing type"));
                    type = errant;
                } else {
                    type = this._schemaTx.transformType(this._type, this._type.getFile(), name, bindings, null);
                }
                this._type.addMember(name, type, token);
            }
            this.addRequired();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this._type.addIssue(new JsonIssue(IIssue.Kind.Error, token, message == null ? DebugLogUtil.getStackTrace((Throwable)e) : message));
        }
    }

    private Bindings handleOpenApiIdiom(Object value) {
        Bindings bindings;
        if (value instanceof String) {
            bindings = new DataBindings();
            bindings.put("type", value);
        } else {
            bindings = (Bindings)value;
        }
        return bindings;
    }

    private void addRequired() {
        Object requiredValue = this._jsonObj.get("required");
        this._type.addRequiredWithTokens(requiredValue);
    }
}

