/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.List;
import java.util.Map;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;

public abstract class JsonSchemaType
implements IJsonParentType {
    private final String _name;
    private final JsonSchemaType _parent;
    private List<IJsonType> _definitions;
    private URL _file;

    JsonSchemaType(String name, JsonSchemaType parent) {
        this._name = name;
        this._parent = parent;
    }

    public URL getFile() {
        return this._file != null ? this._file : this._parent.getFile();
    }

    public void setFile(URL file) {
        this._file = file;
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getIdentifier() {
        return JsonUtil.makeIdentifier((String)this.getName());
    }

    @Override
    public JsonSchemaType getParent() {
        return this._parent;
    }

    @Override
    public List<IJsonType> getDefinitions() {
        return this._definitions;
    }

    @Override
    public void setDefinitions(List<IJsonType> definitions) {
        this._definitions = definitions;
    }

    boolean mergeInnerTypes(IJsonParentType other, IJsonParentType mergedType, Map<String, IJsonParentType> innerTypes) {
        for (Map.Entry<String, IJsonParentType> e : innerTypes.entrySet()) {
            String name = e.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(e.getValue(), innerType) : (IJsonType)e.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaType that = (JsonSchemaType)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static {
        Bootstrap.init();
    }
}

