/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.script.ScriptException;
import manifold.api.fs.IFile;
import manifold.api.json.JsonIssue;
import manifold.api.json.Token;
import manifold.api.json.schema.IllegalSchemaTypeName;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.IIssueContainer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.StreamUtil;

public class JsonIssueContainer
implements IIssueContainer {
    private final IFile _file;
    private final List<IIssue> _issues;

    public JsonIssueContainer() {
        this._issues = Collections.emptyList();
        this._file = null;
    }

    public JsonIssueContainer(ScriptException cause, IFile file) {
        this._issues = new ArrayList<IIssue>();
        this._file = file;
        this.addIssues(cause);
    }

    public JsonIssueContainer(IFile file) {
        this._issues = new ArrayList<IIssue>();
        this._file = file;
    }

    private int findOffset(IFile file, int lineNum, int column) {
        try {
            int offset = 0;
            String content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream()));
            for (int i = 1; i < lineNum; ++i) {
                if (content.length() <= offset) continue;
                offset = content.indexOf(10, offset) + 1;
            }
            return offset + column - 1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int parseNum(String line, char delim) {
        String num = "";
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == delim) {
                try {
                    return Integer.parseInt(num);
                }
                catch (Exception e) {
                    return -1;
                }
            }
            num = num + c;
        }
        return -1;
    }

    public List<IIssue> getIssues() {
        return this._issues;
    }

    public List<IIssue> getWarnings() {
        return Collections.emptyList();
    }

    public List<IIssue> getErrors() {
        return this.getIssues();
    }

    public void addIssues(ScriptException cause) {
        String message = cause.getMessage();
        StringTokenizer tokenizer = new StringTokenizer(message, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (!line.startsWith("[")) continue;
            int lineNum = this.parseNum(line.substring(1), ':');
            int column = this.parseNum(line.substring(line.indexOf(58) + 1) + 1, ']');
            int offset = this.findOffset(this._file, lineNum, column);
            String msg = line.substring(line.indexOf(93) + 1);
            this._issues.add(new JsonIssue(IIssue.Kind.Error, offset, lineNum, column, msg));
        }
    }

    public void addIssues(IllegalSchemaTypeName cause) {
        String message = cause.getMessage();
        Token token = cause.getToken();
        int lineNum = token.getLineNumber();
        int column = token.getColumn();
        int offset = token.getOffset();
        String msg = "Unknown schema type: " + cause.getTypeName();
        this._issues.add(new JsonIssue(IIssue.Kind.Error, offset, lineNum, column, msg));
    }

    public boolean isEmpty() {
        return this._issues == null;
    }

    static {
        Bootstrap.init();
    }
}

