/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import manifold.internal.runtime.Bootstrap;

public enum Type {
    Object("object"),
    Array("array"),
    String("string"),
    Number("number"),
    Integer("integer"),
    Boolean("boolean"),
    Dynamic("dynamic"),
    Null("null");

    private final String _schemaName;

    private Type(String name) {
        this._schemaName = name;
    }

    public static Type fromName(String schemaName) {
        switch (schemaName) {
            case "object": {
                return Object;
            }
            case "array": {
                return Array;
            }
            case "string": {
                return String;
            }
            case "number": {
                return Number;
            }
            case "integer": {
                return Integer;
            }
            case "boolean": {
                return Boolean;
            }
            case "dynmaic": {
                return Dynamic;
            }
            case "null": {
                return Null;
            }
        }
        throw new IllegalArgumentException(schemaName + " is not a valid schema type");
    }

    static {
        Bootstrap.init();
    }
}

