/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;

public class JsonListType
extends JsonSchemaType {
    private IJsonType _componentType;
    private Map<String, IJsonParentType> _innerTypes = Collections.emptyMap();

    public JsonListType(String label, URL source, JsonSchemaType parent) {
        super(label, source, parent);
    }

    @Override
    protected void resolveRefsImpl() {
        super.resolveRefsImpl();
        if (this._componentType instanceof JsonSchemaType) {
            ((JsonSchemaType)this._componentType).resolveRefs();
        } else if (this._componentType instanceof LazyRefJsonType) {
            this._componentType = ((LazyRefJsonType)this._componentType).resolve();
        }
        for (Map.Entry<String, IJsonParentType> entry : new HashSet<Map.Entry<String, IJsonParentType>>(this._innerTypes.entrySet())) {
            IJsonType type = entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            this._innerTypes.put(entry.getKey(), (IJsonParentType)((LazyRefJsonType)type).resolve());
        }
    }

    @Override
    public String getLabel() {
        return super.getName();
    }

    @Override
    public String getName() {
        return "ListOf" + this.getComponentTypeName();
    }

    private String getComponentTypeName() {
        if (this._componentType == null || this._componentType instanceof LazyRefJsonType) {
            return "_undefined_";
        }
        return this._componentType instanceof JsonUnionType ? "Object" : this._componentType.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    @Override
    public String getFqn() {
        return this.getName();
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._innerTypes.isEmpty()) {
            this._innerTypes = new HashMap<String, IJsonParentType>();
        }
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        IJsonType innerType = this._innerTypes.get(name);
        if (innerType == null) {
            List<IJsonType> definitions;
            if (this._componentType instanceof IJsonParentType) {
                innerType = ((IJsonParentType)this._componentType).findChild(name);
            }
            if (innerType == null && (definitions = this.getDefinitions()) != null) {
                for (IJsonType child : definitions) {
                    if (!child.getName().equals(name)) continue;
                    innerType = child;
                    break;
                }
            }
        }
        return innerType;
    }

    public IJsonType getComponentType() {
        return this._componentType;
    }

    public void setComponentType(IJsonType compType) {
        if (this._componentType != null && this._componentType != compType) {
            throw new IllegalStateException("Component type already set to: " + this._componentType.getIdentifier() + ", which is not the same as: " + compType.getIdentifier());
        }
        this._componentType = compType;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._innerTypes;
    }

    IJsonType merge(JsonListType other) {
        JsonListType mergedType = new JsonListType(this.getLabel(), this.getFile(), this.getParent());
        if (!this.getComponentType().equalsStructurally(other.getComponentType())) {
            IJsonType componentType = Json.mergeTypes(this.getComponentType(), other.getComponentType());
            if (componentType != null) {
                mergedType.setComponentType(componentType);
            } else {
                return null;
            }
        }
        if (!this.mergeInnerTypes(other, mergedType, this._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent, mutable);
        }
    }

    @Override
    public boolean equalsStructurally(IJsonType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (!this._componentType.equalsStructurally(that._componentType)) {
            return false;
        }
        return this._innerTypes.size() == that._innerTypes.size() && this._innerTypes.keySet().stream().allMatch(key -> that._innerTypes.containsKey(key) && this._innerTypes.get(key).equalsStructurally(that._innerTypes.get(key)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.isSchemaType()) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (!this._componentType.equals(that._componentType)) {
            return false;
        }
        return this._innerTypes.equals(that._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = this._componentType.hashCode();
        result = 31 * result + this._innerTypes.hashCode();
        return result;
    }
}

