/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonStructureType;
import manifold.api.json.schema.JsonSchemaType;
import manifold.internal.runtime.Bootstrap;

public class JsonUnionType
extends JsonStructureType {
    private Map<String, IJsonType> _constituentTypes = Collections.emptyMap();

    public JsonUnionType(JsonSchemaType parent, URL source, String name) {
        super(parent, source, name);
    }

    public Collection<? extends IJsonType> getConstituents() {
        return this._constituentTypes.values();
    }

    public void addConstituent(String name, IJsonType type) {
        if (this._constituentTypes.isEmpty()) {
            this._constituentTypes = new HashMap<String, IJsonType>();
        }
        this._constituentTypes.put(name, type);
        if (type instanceof IJsonParentType && !this.isDefinition(type)) {
            super.addChild(name, (IJsonParentType)type);
        }
    }

    private boolean isDefinition(IJsonType type) {
        return type.getParent().getName().equals("definitions");
    }

    public IJsonType merge(IJsonType type) {
        IJsonType c;
        IJsonType mergedType = null;
        Iterator<? extends IJsonType> iterator = this.getConstituents().iterator();
        while (iterator.hasNext() && ((mergedType = Json.mergeTypesNoUnion(c = iterator.next(), type)) == null || mergedType == DynamicType.instance())) {
        }
        if (mergedType == null) {
            mergedType = type;
        }
        this.addConstituent(mergedType.getName(), mergedType);
        return this;
    }

    static {
        Bootstrap.init();
    }
}

