/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;

public abstract class JsonSchemaType
implements IJsonParentType {
    private final String _name;
    private final JsonSchemaType _parent;
    private List<IJsonType> _definitions;
    private URL _file;
    private List<JsonIssue> _issues;
    private boolean _bSchemaType;

    protected JsonSchemaType(String name, URL source, JsonSchemaType parent) {
        this._name = name;
        this._parent = parent;
        this._file = source;
        this._issues = Collections.emptyList();
    }

    public abstract String getFqn();

    protected boolean isParentRoot() {
        return this.getParent() == null || this.getParent().getParent() == null && (this.getParent() instanceof JsonListType || !this.getParent().getName().equals("definitions"));
    }

    public URL getFile() {
        return this._file != null ? this._file : (this._parent != null ? this._parent.getFile() : null);
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getIdentifier() {
        return JsonUtil.makeIdentifier((String)this.getName());
    }

    @Override
    public JsonSchemaType getParent() {
        return this._parent;
    }

    @Override
    public List<IJsonType> getDefinitions() {
        return this._definitions;
    }

    @Override
    public void setDefinitions(List<IJsonType> definitions) {
        this._definitions = definitions;
    }

    public boolean isSchemaType() {
        return this._bSchemaType;
    }

    protected void setJsonSchema() {
        this._bSchemaType = true;
    }

    protected boolean mergeInnerTypes(IJsonParentType other, IJsonParentType mergedType, Map<String, IJsonParentType> innerTypes) {
        for (Map.Entry<String, IJsonParentType> e : innerTypes.entrySet()) {
            String name = e.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(e.getValue(), innerType) : (IJsonType)e.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<JsonIssue> getIssues() {
        if (this.getParent() != null) {
            return this.getParent().getIssues();
        }
        return this._issues;
    }

    @Override
    public void addIssue(JsonIssue issue) {
        if (this.getParent() != null) {
            this.getParent().addIssue(issue);
            return;
        }
        if (this._issues.isEmpty()) {
            this._issues = new ArrayList<JsonIssue>();
        }
        this._issues.add(issue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaType that = (JsonSchemaType)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static {
        Bootstrap.init();
    }
}

