/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import extensions.java.net.URL.ManUrlExt;
import extensions.javax.script.Bindings.ManBindingsExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonSchemaType;
import manifold.api.type.ActualName;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;
import manifold.util.ManStringUtil;

public class JsonStructureType
extends JsonSchemaType {
    private List<IJsonParentType> _superTypes;
    private Map<String, IJsonType> _members = new HashMap<String, IJsonType>();
    private Map<String, IJsonParentType> _innerTypes = new HashMap<String, IJsonParentType>();

    public JsonStructureType(JsonSchemaType parent, String name) {
        super(name, parent);
        this._superTypes = new ArrayList<IJsonParentType>();
    }

    public void addSuper(IJsonParentType superType) {
        this._superTypes.add(superType);
    }

    public List<IJsonParentType> getSuperTypes() {
        return this._superTypes;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonParentType findChild(String name) {
        List<IJsonType> definitions;
        IJsonParentType innerType = this._innerTypes.get(name);
        if (innerType == null && (definitions = this.getDefinitions()) != null) {
            for (IJsonType child : definitions) {
                if (!child.getName().equals(name)) continue;
                innerType = (IJsonParentType)child;
                break;
            }
        }
        return innerType;
    }

    public Map<String, IJsonType> getMembers() {
        return this._members;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._innerTypes;
    }

    public void addMember(String name, IJsonType type) {
        IJsonType existingType = this._members.get(name);
        if (existingType != null && existingType != type) {
            if (type == DynamicType.instance()) {
                return;
            }
            if (existingType != DynamicType.instance() && (type = Json.mergeTypes(existingType, type)) == null) {
                throw new RuntimeException("Types disagree for '" + name + "' from array data: " + type.getName() + " vs: " + existingType.getName());
            }
        }
        this._members.put(name, type);
    }

    public IJsonType findMemberType(String name) {
        return this._members.get(name);
    }

    JsonStructureType merge(JsonStructureType other) {
        if (!this.getName().equals(other.getName())) {
            return null;
        }
        JsonStructureType mergedType = new JsonStructureType(this.getParent(), this.getName());
        for (Map.Entry<String, IJsonType> entry : this._members.entrySet()) {
            String memberName = entry.getKey();
            IJsonType memberType = other.findMemberType(memberName);
            memberType = memberType != null ? Json.mergeTypes(entry.getValue(), memberType) : entry.getValue();
            if (memberType != null) {
                mergedType.addMember(memberName, memberType);
                continue;
            }
            return null;
        }
        for (Map.Entry<String, IJsonType> entry : this._innerTypes.entrySet()) {
            String name = entry.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(entry.getValue(), innerType) : entry.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        this.indent(sb, indent);
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name);
        sb.append("@Structural\n");
        this.indent(sb, indent);
        sb.append("public interface ").append(identifier).append(this.addSuperTypes(sb)).append(" {\n");
        this.renderTopLevelFactoryMethods(sb, indent + 2);
        for (String key : this._members.keySet()) {
            String propertyType = this._members.get(key).getName();
            identifier = ManStringUtil.capitalize((String)this.addActualNameAnnotation(sb, indent + 2, key));
            this.indent(sb, indent + 2);
            sb.append(propertyType).append(" get").append(identifier).append("();\n");
            if (!mutable) continue;
            this.indent(sb, indent + 2);
            sb.append("void set").append(identifier).append("(").append(propertyType).append(" $value);\n");
        }
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).render(sb, indent + 2, mutable);
            }
        }
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private String addSuperTypes(StringBuilder sb) {
        for (int i = 0; i < this._superTypes.size(); ++i) {
            IJsonParentType superType = this._superTypes.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(superType.getName());
        }
        return "";
    }

    private String addActualNameAnnotation(StringBuilder sb, int indent, String name) {
        String identifier = JsonUtil.makeIdentifier((String)name);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    private void renderTopLevelFactoryMethods(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("static ").append(this.getName()).append(" create() {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(this.getName()).append(")new javax.script.SimpleBindings();\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toJson() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toJson(this);\n");
        this.indent(sb, indent);
        sb.append("};\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(this);\n");
        this.indent(sb, indent);
        sb.append("};\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml(String name) {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(this, name);\n");
        this.indent(sb, indent);
        sb.append("};\n");
        if (!this.shouldRenderTopLevel(this)) {
            return;
        }
        this.indent(sb, indent);
        sb.append("static ").append(this.getName()).append(" fromJson(String jsonText) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(this.getName()).append(")").append(Json.class.getName()).append(".fromJson(jsonText);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(this.getName()).append(" fromJsonUrl(String url) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(this.getName()).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(new java.net.URL(url));\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(this.getName()).append(" fromJsonUrl(java.net.URL url) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(this.getName()).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(url);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(this.getName()).append(" fromJsonUrl(java.net.URL url, javax.script.Bindings json) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(this.getName()).append(")").append(ManUrlExt.class.getName()).append(".postForJsonContent(url, json);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(this.getName()).append(" fromJsonFile(java.io.File file) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(this.getName()).append(")fromJsonUrl(file.toURI().toURL());\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private boolean shouldRenderTopLevel(IJsonParentType type) {
        IJsonParentType parent = type.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof JsonListType) {
            return this.shouldRenderTopLevel(parent);
        }
        return false;
    }

    private void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType type = (JsonStructureType)o;
        if (!this._superTypes.equals(type._superTypes)) {
            return false;
        }
        if (!this._members.equals(type._members)) {
            return false;
        }
        return this._innerTypes.equals(type._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._superTypes.hashCode();
        result = 31 * result + this._members.hashCode();
        result = 31 * result + this._innerTypes.hashCode();
        return result;
    }

    static {
        Bootstrap.init();
    }
}

