/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.extensions.manifold.rt.api.Bindings;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import manifold.json.rt.Json;
import manifold.json.rt.api.DataBindings;
import manifold.json.rt.api.IJsonBindingsTranslator;
import manifold.json.rt.extensions.java.net.URL.ManUrlExt;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.Pair;

@Extension
public class ManBindingsExt {
    public static String toJson(@This Bindings thiz) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.toJson(thiz, sb, 0);
        return sb.toString();
    }

    public static String toYaml(@This Bindings thiz) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.toYaml(thiz, sb);
        return sb.toString();
    }

    public static void toJson(@This Bindings thiz, StringBuilder target, int margin) {
        Json.toJson((Map)thiz, target, margin);
    }

    public static void toYaml(@This Bindings thiz, StringBuilder target) {
        IJsonBindingsTranslator Yaml = IJsonBindingsTranslator.get("YAML");
        Yaml.fromBindings(thiz, target);
    }

    private static boolean isNewLine(StringBuilder sb) {
        return sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
    }

    public static void listToJson(StringBuilder target, int indent, List value) {
        target.append('[');
        if (value.size() > 0) {
            target.append("\n");
            int iSize = value.size();
            for (int i = 0; i < iSize; ++i) {
                Object comp = value.get(i);
                if (comp instanceof Pair) {
                    comp = ((Pair)comp).getSecond();
                }
                if (comp instanceof Bindings) {
                    ManBindingsExt.toJson((Bindings)comp, target, indent + 4);
                } else if (comp instanceof List) {
                    ManBindingsExt.listToJson(target, indent + 4, (List)comp);
                } else {
                    ManBindingsExt.indent(target, indent + 4);
                    Json.appendValue(target, comp);
                }
                ManBindingsExt.appendCommaNewLine(target, i < iSize - 1);
            }
        }
        ManBindingsExt.indent(target, indent + 2);
        target.append("]");
    }

    public static String listToJson(List list) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.listToJson(sb, 0, list);
        return sb.toString();
    }

    public static String toXml(@This Bindings thiz) {
        return ManBindingsExt.toXml(thiz, "object");
    }

    public static String toXml(@This Bindings thiz, String name) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.toXml(thiz, name, sb, 0);
        return sb.toString();
    }

    public static void toXml(@This Bindings thiz, String name, StringBuilder target, int indent) {
        IJsonBindingsTranslator Xml = IJsonBindingsTranslator.get("XML");
        Xml.fromBindings(thiz, name, target, indent);
    }

    public static String toCsv(@This Bindings thiz) {
        return ManBindingsExt.toCsv(thiz, "object");
    }

    public static String toCsv(@This Bindings thiz, String name) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.toCsv(thiz, name, sb, 0);
        return sb.toString();
    }

    public static void toCsv(@This Bindings thiz, String name, StringBuilder target, int indent) {
        IJsonBindingsTranslator Csv = IJsonBindingsTranslator.get("CSV");
        Csv.fromBindings(thiz, name, target, indent);
    }

    public static URL makeUrl(@This Bindings thiz, String url) {
        return ManUrlExt.makeUrl(url, thiz);
    }

    public static Object sendJsonRequest(@This Bindings thiz, String httpMethod, String url) {
        try {
            return ManUrlExt.sendJsonRequest(new URL(url), httpMethod, thiz);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object sendYamlRequest(@This Bindings thiz, String httpMethod, String url) {
        try {
            return ManUrlExt.sendYamlRequest(new URL(url), httpMethod, thiz);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    public static Bindings deepCopy(@This Bindings thiz) {
        return ManBindingsExt.deepCopy(thiz, DataBindings::new);
    }

    public static <E extends Bindings> E deepCopy(@This Bindings thiz, Function<Integer, E> bindingsSupplier) {
        return (E)((Bindings)ManBindingsExt.deepCopyValue(thiz, bindingsSupplier));
    }

    @Extension
    public static <E extends Map<String, Object>> Object deepCopyValue(Object value, Function<Integer, E> bindingsSupplier) {
        if (value instanceof Map) {
            Map dataMap = (Map)value;
            Map copy = (Map)bindingsSupplier.apply(dataMap.size());
            dataMap.forEach((k, v) -> copy.put(k, ManBindingsExt.deepCopyValue(v, bindingsSupplier)));
            return copy;
        }
        if (value instanceof Iterable) {
            Iterable list = (Iterable)value;
            ArrayList copy = new ArrayList();
            list.forEach(e -> copy.add(ManBindingsExt.deepCopyValue(e, bindingsSupplier)));
            return copy;
        }
        return value;
    }
}

