/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.fs.def.FileFragmentImpl;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.js.JavascriptClass;
import manifold.js.JavascriptModel;
import manifold.js.rt.JsRuntime;
import manifold.js.rt.parser.tree.FunctionNode;
import manifold.js.rt.parser.tree.Node;
import manifold.js.rt.parser.tree.ParameterNode;
import manifold.js.rt.parser.tree.ProgramNode;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.FragmentValue;
import manifold.rt.api.SourcePosition;
import manifold.rt.api.util.ManEscapeUtil;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptProgram {
    static SrcClass genProgram(String fqn, ProgramNode programNode, IFile file) {
        String url;
        SrcClass clazz = (SrcClass)((SrcClass)((SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.Class).imports(new Class[]{JsRuntime.class})).imports(new Class[]{SourcePosition.class})).imports(new Class[]{FragmentValue.class});
        if (file instanceof IFileFragment) {
            clazz.addAnnotation(new SrcAnnotationExpression(FragmentValue.class.getSimpleName()).addArgument("methodName", String.class, (Object)"fragmentValue").addArgument("type", String.class, (Object)Object.class.getTypeName()));
            try {
                url = ((IFileFragment)file).getEnclosingFile().toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(8L)).initializer(JsRuntime.class.getSimpleName() + ".initDirect(\"" + ManEscapeUtil.escapeForJava((String)((FileFragmentImpl)file).getContent()) + "\", \"" + url + "\")"));
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name("fragmentValue")).modifiers(9L)).returns(Object.class.getSimpleName());
            srcMethod.body("return " + JsRuntime.class.getSimpleName() + ".evaluate(\"" + ManEscapeUtil.escapeForJava((String)((FileFragmentImpl)file).getContent()) + "\", \"" + url + "\");");
            clazz.addMethod(srcMethod);
        } else {
            try {
                url = file.toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            String source = ResourceFileTypeManifold.getContent((IFile)file);
            source = ManEscapeUtil.escapeForJavaStringLiteral((String)source);
            clazz.addField(((SrcField)((SrcField)new SrcField("SCOPE", ScriptableObject.class).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class))).modifiers(8L)).initializer(JsRuntime.class.getSimpleName() + ".initProg(\"" + fqn + "\",\"" + source + "\",\"" + url + "\")"));
        }
        clazz.addConstructor((SrcConstructor)((SrcConstructor)new SrcConstructor().modifiers(2L)).body(new SrcStatementBlock()));
        for (FunctionNode node : programNode.getChildren(FunctionNode.class)) {
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers(9L)).returns(node.getReturnType());
            ((SrcMethod)srcMethod.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)programNode.getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, JavascriptProgram.absoluteOffset(node.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())))).body("return " + JsRuntime.class.getSimpleName() + ".invokeProg(SCOPE, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(JavascriptProgram.makeSrcParameters((Node)node, (SrcAnnotated)srcMethod)) + ");");
            clazz.addMethod(srcMethod);
        }
        return clazz;
    }

    static List<SrcParameter> makeSrcParameters(Node node, SrcAnnotated srcMethod) {
        ParameterNode paramNode = (ParameterNode)node.getFirstChild(ParameterNode.class);
        List<Object> srcParameters = paramNode != null ? JavascriptClass.toParamList(paramNode) : Collections.emptyList();
        for (SrcParameter srcParameter : srcParameters) {
            srcMethod.addParam(srcParameter);
        }
        return srcParameters;
    }

    static String generateArgList(List<SrcParameter> srcParameters) {
        StringBuilder sb = new StringBuilder();
        for (SrcParameter srcParameter : srcParameters) {
            sb.append(",");
            sb.append(srcParameter.getSimpleName());
        }
        return sb.toString();
    }

    static IFile loadSrcForName(JavascriptModel model, String fqn, String fileExt) {
        List filesForType = JavascriptProgram.findJavascriptManifold(model, fileExt).findFilesForType(fqn);
        if (filesForType.isEmpty()) {
            throw new IllegalStateException("Could not find a ." + fileExt + " file for type: " + fqn);
        }
        if (filesForType.size() > 1) {
            System.err.println("===\nWARNING: more than one ." + fileExt + " file corresponds with type: '" + fqn + "':\n");
            filesForType.forEach(file -> System.err.println(file.toString()));
            System.err.println("using the first one: " + filesForType.get(0) + "\n===");
        }
        return (IFile)filesForType.get(0);
    }

    private static ITypeManifold findJavascriptManifold(JavascriptModel model, String fileExt) {
        ITypeManifold tm = model.getModule().getTypeManifolds().stream().filter(e -> e.handlesFileExtension(fileExt)).findFirst().orElse(null);
        if (tm == null) {
            throw new IllegalStateException("Could not find type manifold for extension: " + fileExt);
        }
        return tm;
    }

    private static Object absoluteOffset(int offset, IFile file) {
        if (file instanceof IFileFragment) {
            offset += ((IFileFragment)file).getOffset();
        }
        return offset;
    }
}

