/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Collections;
import java.util.List;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.type.SourcePosition;
import manifold.js.JavascriptProgram;
import manifold.js.SharedScope;
import manifold.js.parser.Parser;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.ClassFunctionNode;
import manifold.js.parser.tree.ClassNode;
import manifold.js.parser.tree.ConstructorNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParameterNode;
import manifold.js.parser.tree.ProgramNode;
import manifold.js.parser.tree.PropertyNode;
import manifold.util.ManClassUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptClass {
    private static ThreadLocal<Long> uid = new ThreadLocal();

    static SrcClass genClass(String fqn, ProgramNode programNode, IFile file) {
        ClassNode classNode = programNode.getFirstChild(ClassNode.class);
        SrcClass clazz = (SrcClass)((SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.Class).imports(new Class[]{JavascriptClass.class})).imports(new Class[]{SourcePosition.class});
        clazz.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)programNode.getUrl().toString()).addArgument("feature", String.class, (Object)ManClassUtil.getShortClassName((String)fqn)).addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(classNode.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(classNode.getEnd().getOffset() - classNode.getStart().getOffset())));
        String superClass = classNode.getSuperClass();
        if (superClass != null) {
            clazz.superClass(superClass);
        }
        clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(74L)).initializer("null"));
        clazz.addField(((SrcField)new SrcField("UID", Long.TYPE).modifiers(74L)).initializer("0L"));
        clazz.addField(new SrcField("_context", ScriptableObject.class));
        JavascriptClass.addConstructor(clazz, classNode, file);
        JavascriptClass.addUtilityMethods(clazz, classNode, fqn);
        JavascriptClass.addMethods(fqn, clazz, classNode, file);
        JavascriptClass.addProperties(fqn, clazz, classNode, file);
        return clazz;
    }

    private static void addConstructor(SrcClass clazz, ClassNode classNode, IFile file) {
        List<SrcParameter> srcParameters;
        ConstructorNode constructor = classNode.getFirstChild(ConstructorNode.class);
        SrcConstructor ctor = (SrcConstructor)((SrcConstructor)new SrcConstructor().name(classNode.getName())).modifiers(1L);
        if (constructor != null) {
            srcParameters = JavascriptProgram.makeSrcParameters(constructor, (SrcAnnotated)ctor);
            ctor.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)"constructor").addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(constructor.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(constructor.getEnd().getOffset() - constructor.getStart().getOffset())));
        } else {
            srcParameters = Collections.emptyList();
        }
        ctor.body("_context = " + JavascriptClass.class.getSimpleName() + ".initInstance(getScope(), \"" + classNode.getName() + "\"" + JavascriptProgram.generateArgList(srcParameters) + ");");
        clazz.addConstructor(ctor);
    }

    private static void addUtilityMethods(SrcClass clazz, ClassNode classNode, String fqn) {
        long uid = JavascriptClass.incUid();
        SrcMethod m = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("getScope")).modifiers(10L)).returns(ScriptableObject.class)).body("if(" + uid + "L != UID) {\n      synchronized(" + classNode.getName() + ".class) {\n        if(" + uid + "L != UID) {\n          UID = " + uid + "L;\n          SCOPE = JavascriptClass.init(\"" + fqn + "\");\n        }\n      }\n    }\n    return SCOPE;");
        clazz.addMethod((AbstractSrcMethod)m);
    }

    private static long incUid() {
        Long id = uid.get();
        if (id == null) {
            id = 1L;
            uid.set(id);
        }
        id = id + 1L;
        uid.set(id);
        return id;
    }

    private static void addMethods(String fqn, SrcClass clazz, ClassNode classNode, IFile file) {
        for (ClassFunctionNode node : classNode.getChildren(ClassFunctionNode.class)) {
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers((long)(1 | (node.isStatic() ? 8 : 0)))).returns(node.getReturnType());
            srcMethod.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(node.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
            ParameterNode parameters = node.getFirstChild(ParameterNode.class);
            for (SrcParameter srcParameter : parameters.toParamList()) {
                srcMethod.addParam(srcParameter);
            }
            if (node.isStatic()) {
                srcMethod.body("return JavascriptClass.invokeStatic(getScope(), \"" + ManClassUtil.getShortClassName((String)fqn) + "\", \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(parameters.toParamList()) + ");");
            } else {
                srcMethod.body("return JavascriptClass.invoke(_context, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(parameters.toParamList()) + ");");
            }
            clazz.addMethod(srcMethod);
        }
    }

    private static void addProperties(String fqn, SrcClass clazz, ClassNode classNode, IFile file) {
        for (PropertyNode node : classNode.getChildren(PropertyNode.class)) {
            String name = node.getName();
            String capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
            if (node.isSetter()) {
                AbstractSrcMethod setter = ((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("set" + capitalizedName)).modifiers((long)(1 | (node.isStatic() ? 8 : 0)))).addParam("val", Object.class)).returns("void");
                setter.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(node.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
                if (node.isStatic()) {
                    setter.body("JavascriptClass.setStaticProp(getScope(), \"" + ManClassUtil.getShortClassName((String)fqn) + "\", \"" + name + "\", val);");
                } else {
                    setter.body("JavascriptClass.setProp(_context, \"" + name + "\", val);");
                }
                clazz.addMethod(setter);
                continue;
            }
            AbstractSrcMethod getter = ((SrcMethod)((SrcMethod)new SrcMethod().name("get" + capitalizedName)).modifiers((long)(1 | (node.isStatic() ? 8 : 0)))).returns(node.getReturnType());
            getter.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)node.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
            if (node.isStatic()) {
                getter.body("return JavascriptClass.getStaticProp(getScope(), \"" + ManClassUtil.getShortClassName((String)fqn) + "\", \"" + name + "\");");
            } else {
                getter.body("return JavascriptClass.getProp(_context, \"" + name + "\");");
            }
            clazz.addMethod(getter);
        }
    }

    public static <T> T invoke(ScriptableObject scope, String func, Object ... args) {
        return (T)ScriptableObject.callMethod((Scriptable)scope, (String)func, (Object[])args);
    }

    public static <T> T invokeStatic(ScriptableObject scope, String className, String func, Object ... args) {
        return (T)ScriptableObject.callMethod((Scriptable)((Scriptable)scope.get(className, (Scriptable)scope)), (String)func, (Object[])args);
    }

    public static Object getProp(ScriptableObject scope, String prop) {
        return ScriptableObject.getProperty((Scriptable)scope, (String)prop);
    }

    public static Object getStaticProp(ScriptableObject scope, String className, String prop) {
        return ScriptableObject.getProperty((Scriptable)((Scriptable)scope.get(className, (Scriptable)scope)), (String)prop);
    }

    public static void setProp(ScriptableObject scope, String prop, Object value) {
        ScriptableObject.putProperty((Scriptable)scope, (String)prop, (Object)value);
    }

    public static void setStaticProp(ScriptableObject scope, String className, String prop, Object value) {
        ScriptableObject.putProperty((Scriptable)((Scriptable)scope.get(className, (Scriptable)scope)), (String)prop, (Object)value);
    }

    public static ScriptableObject init(String programName) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(JavascriptProgram.loadSrcForName(programName, "js")));
        Node programNode = parser.parse();
        ClassNode classNode = programNode.getFirstChild(ClassNode.class);
        String script = classNode.genCode();
        Context.getCurrentContext().evaluateString((Scriptable)scope, script, programName, 1, null);
        return scope;
    }

    public static ScriptableObject initInstance(ScriptableObject scope, String name, Object ... args) {
        return (ScriptableObject)Context.getCurrentContext().newObject((Scriptable)scope, name, args);
    }

    private static Object absoluteOffset(int offset, IFile file) {
        if (file instanceof IFileFragment) {
            offset += ((IFileFragment)file).getOffset();
        }
        return offset;
    }
}

