/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.js.JavascriptProgram;
import manifold.js.SharedScope;
import manifold.js.parser.TemplateParser;
import manifold.js.parser.TemplateTokenizer;
import manifold.js.parser.tree.template.JSTNode;
import manifold.js.parser.tree.template.RawStringNode;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptTemplate {
    private static ThreadLocal<Integer> _counter = ThreadLocal.withInitial(() -> 0);

    static SrcClass genClass(String fqn, JSTNode jstNode) {
        SrcClass clazz = new SrcClass(fqn, AbstractSrcClass.Kind.Class);
        clazz.addField(((SrcField)new SrcField("TEMPLATE_NODE", JSTNode.class).modifiers(24L)).initializer(JavascriptTemplate.class.getTypeName() + ".initNode(\"" + fqn + "\")"));
        clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(24L)).initializer(JavascriptTemplate.class.getTypeName() + ".initEngine(TEMPLATE_NODE)"));
        AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name("renderToString")).modifiers(9L)).returns(String.class);
        List<SrcParameter> srcParameters = JavascriptProgram.makeSrcParameters(jstNode, (SrcAnnotated)srcMethod);
        srcMethod.body("return " + JavascriptTemplate.class.getTypeName() + ".renderToStringImpl(SCOPE, TEMPLATE_NODE" + JavascriptProgram.generateArgList(srcParameters) + ");");
        clazz.addMethod(srcMethod);
        return clazz;
    }

    public static String renderToStringImpl(ScriptableObject scope, JSTNode templateNode, Object ... args) {
        try {
            List rawStrings;
            Object[] argsWithStrings = Arrays.copyOf(args, args.length + 1);
            argsWithStrings[argsWithStrings.length - 1] = rawStrings = templateNode.getChildren(RawStringNode.class).stream().map(node -> node.genCode()).collect(Collectors.toList());
            Function renderToString = (Function)scope.get("renderToString", (Scriptable)scope);
            return (String)renderToString.call(Context.getCurrentContext(), (Scriptable)scope, (Scriptable)scope, argsWithStrings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptableObject initEngine(JSTNode templateNode) {
        ScriptableObject scope = SharedScope.newStaticScope();
        String name = "template_" + _counter.get();
        _counter.set(_counter.get() + 1);
        Context.getCurrentContext().evaluateString((Scriptable)scope, templateNode.genCode(), name, 1, null);
        return scope;
    }

    public static JSTNode initNode(String programName) {
        TemplateParser parser = new TemplateParser(new TemplateTokenizer(JavascriptProgram.loadSrcForName(programName, "jst"), true));
        return (JSTNode)parser.parse();
    }
}

