/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.fs.def.FileFragmentImpl;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.type.FragmentValue;
import manifold.api.type.ITypeManifold;
import manifold.api.type.SourcePosition;
import manifold.api.util.ManEscapeUtil;
import manifold.internal.host.RuntimeManifoldHost;
import manifold.js.SharedScope;
import manifold.js.parser.Parser;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.FunctionNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParameterNode;
import manifold.js.parser.tree.ProgramNode;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptProgram {
    private static ThreadLocal<Integer> _counter = ThreadLocal.withInitial(() -> 0);

    static SrcClass genProgram(String fqn, ProgramNode programNode, IFile file) {
        SrcClass clazz = (SrcClass)((SrcClass)((SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.Class).superClass(JavascriptProgram.class)).imports(new Class[]{SourcePosition.class})).imports(new Class[]{FragmentValue.class});
        if (file instanceof IFileFragment) {
            String url;
            clazz.addAnnotation(new SrcAnnotationExpression(FragmentValue.class.getSimpleName()).addArgument("methodName", String.class, (Object)"fragmentValue").addArgument("type", String.class, (Object)Object.class.getTypeName()));
            try {
                url = ((IFileFragment)file).getEnclosingFile().toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(8L)).initializer("initDirect(\"" + ManEscapeUtil.escapeForJava((String)((FileFragmentImpl)file).getContent()) + "\", \"" + url + "\")"));
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name("fragmentValue")).modifiers(9L)).returns(Object.class.getSimpleName());
            srcMethod.body("return evaluate(\"" + ManEscapeUtil.escapeForJava((String)((FileFragmentImpl)file).getContent()) + "\", \"" + url + "\");");
            clazz.addMethod(srcMethod);
        } else {
            clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(8L)).initializer("init(\"" + fqn + "\")"));
        }
        clazz.addConstructor((SrcConstructor)((SrcConstructor)new SrcConstructor().modifiers(2L)).body(new SrcStatementBlock()));
        for (FunctionNode node : programNode.getChildren(FunctionNode.class)) {
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers(9L)).returns(node.getReturnType());
            ((SrcMethod)srcMethod.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)programNode.getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, JavascriptProgram.absoluteOffset(node.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())))).body("return invoke(SCOPE, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(JavascriptProgram.makeSrcParameters(node, (SrcAnnotated)srcMethod)) + ");");
            clazz.addMethod(srcMethod);
        }
        return clazz;
    }

    static List<SrcParameter> makeSrcParameters(Node node, SrcAnnotated srcMethod) {
        ParameterNode paramNode = node.getFirstChild(ParameterNode.class);
        List<Object> srcParameters = paramNode != null ? paramNode.toParamList() : Collections.emptyList();
        for (SrcParameter srcParameter : srcParameters) {
            srcMethod.addParam(srcParameter);
        }
        return srcParameters;
    }

    static String generateArgList(List<SrcParameter> srcParameters) {
        StringBuilder sb = new StringBuilder();
        for (SrcParameter srcParameter : srcParameters) {
            sb.append(",");
            sb.append(srcParameter.getSimpleName());
        }
        return sb.toString();
    }

    public static <T> T invoke(ScriptableObject scope, String func, Object ... args) {
        try {
            Function renderToString = (Function)scope.get(func, (Scriptable)scope);
            return (T)renderToString.call(Context.getCurrentContext(), (Scriptable)scope, (Scriptable)scope, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptableObject init(String programName) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(JavascriptProgram.loadSrcForName(programName, "js")));
        Node programNode = parser.parse();
        Context.getCurrentContext().evaluateString((Scriptable)scope, programNode.genCode(), programName, 1, null);
        return scope;
    }

    public static ScriptableObject initDirect(String source, String url) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(source, url));
        Node programNode = parser.parse();
        Context.getCurrentContext().evaluateString((Scriptable)scope, programNode.genCode(), "direct_" + _counter.get(), 1, null);
        _counter.set(_counter.get() + 1);
        return scope;
    }

    protected static Object evaluate(String source, String url) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(source, url));
        Node programNode = parser.parse();
        return Context.getCurrentContext().evaluateString((Scriptable)scope, programNode.genCode(), "evaluate_js", 1, null);
    }

    static IFile loadSrcForName(String fqn, String fileExt) {
        List filesForType = JavascriptProgram.findJavascriptManifold(fileExt).findFilesForType(fqn);
        if (filesForType.isEmpty()) {
            throw new IllegalStateException("Could not find a ." + fileExt + " file for type: " + fqn);
        }
        if (filesForType.size() > 1) {
            System.err.println("===\nWARNING: more than one ." + fileExt + " file corresponds with type: '" + fqn + "':\n");
            filesForType.forEach(file -> System.err.println(file.toString()));
            System.err.println("using the first one: " + filesForType.get(0) + "\n===");
        }
        return (IFile)filesForType.get(0);
    }

    private static ITypeManifold findJavascriptManifold(String fileExt) {
        ITypeManifold tm = RuntimeManifoldHost.get().getSingleModule().getTypeManifolds().stream().filter(e -> e.handlesFileExtension(fileExt)).findFirst().orElse(null);
        if (tm == null) {
            throw new IllegalStateException("Could not find type manifold for extension: " + fileExt);
        }
        return tm;
    }

    private static Object absoluteOffset(int offset, IFile file) {
        if (file instanceof IFileFragment) {
            offset += ((IFileFragment)file).getOffset();
        }
        return offset;
    }
}

