/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser;

import java.util.HashMap;
import java.util.Stack;
import manifold.api.fs.IFile;
import manifold.js.parser.Token;
import manifold.js.parser.TokenType;
import manifold.js.parser.Tokenizer;

public class TemplateTokenizer
extends Tokenizer {
    private boolean _inRawString;
    private boolean _inExpression;
    private boolean _inStatement;
    private boolean _isJST;
    private String exprStart;
    private HashMap<String, String> _puncEnterExitMap;
    private Stack<String> _curlyStack;

    public TemplateTokenizer(IFile file, boolean isJST) {
        super(file);
        this.init(isJST);
    }

    TemplateTokenizer(String subtext, boolean isJST) {
        super(subtext, null);
        this.init(isJST);
    }

    private void init(boolean isJST) {
        this._isJST = isJST;
        this._inRawString = true;
        this._curlyStack = new Stack();
        this._puncEnterExitMap = new HashMap();
        this._puncEnterExitMap.put("${", "}");
        if (isJST) {
            this._puncEnterExitMap.put("<%", "%>");
            this._puncEnterExitMap.put("<%=", "%>");
            this._puncEnterExitMap.put("<%@", "%>");
        }
    }

    public boolean isJST() {
        return this._isJST;
    }

    @Override
    public Token next() {
        Token toke;
        if (this.reachedEOF()) {
            toke = this.newToken(TokenType.EOF, "EOF");
        } else if (this._inRawString) {
            toke = this.consumeRawString();
        } else {
            if (this._inExpression || this._inStatement) {
                if (this.checkForExpressionExit()) {
                    return this.consumeTemplatePunc();
                }
                Token supe = super.next();
                if (supe.getType() == TokenType.PUNCTUATION && supe.getValue().equals("}")) {
                    this._curlyStack.pop();
                }
                if (supe.getType() == TokenType.PUNCTUATION && supe.getValue().equals("{")) {
                    this._curlyStack.push("{");
                }
                return supe;
            }
            toke = this.consumeTemplatePunc();
        }
        return toke;
    }

    private Token consumeTemplatePunc() {
        String punc = String.valueOf(this.currChar());
        switch (this.currChar()) {
            case '$': {
                this.nextChar();
                punc = punc + this.currChar();
                this.nextChar();
                this.setInExpression();
                this._curlyStack.push("${");
                break;
            }
            case '<': {
                this.nextChar();
                punc = punc + this.currChar();
                this.nextChar();
                if (this.currChar() == '@') {
                    punc = punc + this.currChar();
                    this.nextChar();
                    this.setInStatement();
                    break;
                }
                if (this.currChar() == '=') {
                    punc = punc + this.currChar();
                    this.nextChar();
                    this.setInExpression();
                    break;
                }
                this.setInStatement();
                break;
            }
            case '%': {
                this.nextChar();
                punc = punc + this.currChar();
                this.nextChar();
                punc = punc + this.consumeNewLineFollowingStatement();
                this.setInRawString();
                break;
            }
            case '}': {
                this.nextChar();
                this.setInRawString();
            }
        }
        if (this._inExpression || this._inStatement) {
            this.exprStart = punc;
        }
        return this.newToken(TokenType.TEMPLATEPUNC, punc);
    }

    private String consumeNewLineFollowingStatement() {
        if (!this._inStatement) {
            return "";
        }
        String newLine = "";
        if (this.currChar() == '\r') {
            newLine = newLine + this.currChar();
            this.nextChar();
        }
        if (this.currChar() == '\n') {
            newLine = newLine + this.currChar();
            this.nextChar();
        }
        return newLine;
    }

    private Token consumeRawString() {
        StringBuilder val = new StringBuilder();
        while (!this.reachedEOF()) {
            if (this.checkForExpressionEnter()) {
                this._inRawString = false;
                break;
            }
            if (!this._isJST && TokenType.isLineTerminator(this.currChar())) {
                if (this.currChar() == '\r' && this.peek() == '\n') {
                    this.nextChar();
                }
                val.append("\\n");
            } else {
                val.append(this.currChar());
            }
            this.nextChar();
        }
        return this.newToken(TokenType.RAWSTRING, val.toString());
    }

    private boolean checkForExpressionEnter() {
        if (this.currChar() == '\\' && (this.peek() == '<' || this.peek() == '$')) {
            this.nextChar();
            return false;
        }
        this.exprStart = this._puncEnterExitMap.get(String.valueOf(this.currChar()) + this.peek());
        return this.exprStart != null;
    }

    private boolean checkForExpressionExit() {
        if (this.exprStart.equals("${") && this.currChar() == '}' && this._curlyStack.peek().equals("${")) {
            return true;
        }
        return !this.exprStart.equals("${") && this.currChar() == '%' && this.peek() == '>';
    }

    private void setInRawString() {
        this._inRawString = true;
        this._inStatement = false;
        this._inExpression = false;
    }

    private void setInStatement() {
        this._inStatement = true;
        this._inRawString = false;
    }

    private void setInExpression() {
        this._inExpression = true;
        this._inRawString = false;
    }
}

