/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser;

import java.util.HashMap;
import java.util.Stack;
import manifold.api.fs.IFile;
import manifold.internal.runtime.Bootstrap;
import manifold.js.parser.Token;
import manifold.js.parser.TokenType;
import manifold.js.parser.Tokenizer;

public class TemplateTokenizer
extends Tokenizer {
    private boolean inRawString;
    private boolean inStatementOrExpression;
    private boolean _isJST;
    private String exprStart;
    private HashMap<String, String> puncEnterExitMap;
    private Stack<String> curlyStack;

    public TemplateTokenizer(IFile file, boolean isJST) {
        super(file);
        this.init(isJST);
    }

    TemplateTokenizer(String subtext, boolean isJST) {
        super(subtext);
        this.init(isJST);
    }

    private void init(boolean isJST) {
        this._isJST = isJST;
        this.inRawString = true;
        this.inStatementOrExpression = false;
        this.curlyStack = new Stack();
        this.puncEnterExitMap = new HashMap();
        this.puncEnterExitMap.put("${", "}");
        if (isJST) {
            this.puncEnterExitMap.put("<%", "%>");
            this.puncEnterExitMap.put("<%=", "%>");
            this.puncEnterExitMap.put("<%@", "%>");
        }
    }

    public boolean isJST() {
        return this._isJST;
    }

    @Override
    public Token next() {
        Token toke;
        if (this.reachedEOF()) {
            toke = this.newToken(TokenType.EOF, "EOF");
        } else if (this.inRawString) {
            toke = this.consumeRawString();
        } else {
            if (this.inStatementOrExpression) {
                if (this.checkForExpressionExit()) {
                    return this.consumeTemplatePunc();
                }
                Token supe = super.next();
                if (supe.getType() == TokenType.PUNCTUATION && supe.getValue().equals("}")) {
                    this.curlyStack.pop();
                }
                if (supe.getType() == TokenType.PUNCTUATION && supe.getValue().equals("{")) {
                    this.curlyStack.push("{");
                }
                return supe;
            }
            toke = this.consumeTemplatePunc();
        }
        return toke;
    }

    private Token consumeTemplatePunc() {
        String punc = String.valueOf(this.currChar());
        switch (this.currChar()) {
            case '$': {
                this.nextChar();
                punc = punc + this.currChar();
                this.nextChar();
                this.setInStatementOrExpression();
                this.curlyStack.push("${");
                break;
            }
            case '<': {
                this.nextChar();
                punc = punc + this.currChar();
                this.nextChar();
                if (this.currChar() == '@' || this.currChar() == '=') {
                    punc = punc + this.currChar();
                    this.nextChar();
                }
                this.setInStatementOrExpression();
                break;
            }
            case '%': {
                this.nextChar();
                punc = punc + this.currChar();
                this.nextChar();
                this.setInRawString();
                break;
            }
            case '}': {
                this.nextChar();
                this.setInRawString();
            }
        }
        if (this.inStatementOrExpression) {
            this.exprStart = punc;
        }
        return this.newToken(TokenType.TEMPLATEPUNC, punc);
    }

    private Token consumeRawString() {
        StringBuilder val = new StringBuilder();
        while (!this.reachedEOF()) {
            if (this.checkForExpressionEnter()) {
                this.inRawString = false;
                break;
            }
            if (!this._isJST && TokenType.isLineTerminator(this.currChar())) {
                if (this.currChar() == '\r' && this.peek() == '\n') {
                    this.nextChar();
                }
                val.append("\\n");
            } else {
                val.append(this.currChar());
            }
            this.nextChar();
        }
        return this.newToken(TokenType.RAWSTRING, val.toString());
    }

    private boolean checkForExpressionEnter() {
        if (this.currChar() == '\\' && (this.peek() == '<' || this.peek() == '$')) {
            this.nextChar();
            return false;
        }
        this.exprStart = this.puncEnterExitMap.get(String.valueOf(this.currChar()) + this.peek());
        return this.exprStart != null;
    }

    private boolean checkForExpressionExit() {
        if (this.exprStart.equals("${") && this.currChar() == '}' && this.curlyStack.peek().equals("${")) {
            return true;
        }
        return !this.exprStart.equals("${") && this.currChar() == '%' && this.peek() == '>';
    }

    private void setInRawString() {
        this.inRawString = true;
        this.inStatementOrExpression = false;
    }

    private void setInStatementOrExpression() {
        this.inStatementOrExpression = true;
        this.inRawString = false;
    }

    static {
        Bootstrap.init();
    }
}

