/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree.template;

import manifold.js.parser.tree.ImportNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParameterNode;
import manifold.js.parser.tree.template.ExpressionNode;
import manifold.js.parser.tree.template.RawStringNode;
import manifold.js.parser.tree.template.StatementNode;

public class JSTNode
extends Node {
    private final String STR_BUILDER = "_strTemplateBuilder";
    private final String RAW_STR_LIST = "_rawStrList";
    private String TEMPLATE_HEADER1 = "function renderToString(";
    private String TEMPLATE_HEADER2 = "_rawStrList) {_strTemplateBuilder = '';";
    private final String TEMPLATE_FOOTER = "\n\treturn _strTemplateBuilder;\n}";

    public JSTNode() {
        super(null);
    }

    @Override
    public String genCode() {
        ParameterNode paramNode = this.getFirstChild(ParameterNode.class);
        String parameterCode = "";
        if (paramNode != null) {
            parameterCode = paramNode.genCode();
            if (paramNode.genCode().length() > 0) {
                parameterCode = parameterCode + ", ";
            }
        }
        StringBuilder code = new StringBuilder();
        for (ImportNode node : this.getChildren(ImportNode.class)) {
            code.append("\n").append(node.genCode());
        }
        code.append("\n").append(this.TEMPLATE_HEADER1).append(parameterCode).append(this.TEMPLATE_HEADER2);
        int rawStringCount = 0;
        for (Node node : this.getChildren()) {
            if (node instanceof RawStringNode) {
                this.addRawString(code, rawStringCount);
                ++rawStringCount;
                continue;
            }
            if (node instanceof ExpressionNode) {
                this.addExpression(code, (ExpressionNode)node);
                continue;
            }
            if (!(node instanceof StatementNode)) continue;
            this.addStatement(code, (StatementNode)node);
        }
        code.append("\n\treturn _strTemplateBuilder;\n}");
        return code.toString();
    }

    private void addExpression(StringBuilder code, ExpressionNode node) {
        code.append("\n\t").append("_strTemplateBuilder").append(" += ").append(node.genCode());
    }

    private void addStatement(StringBuilder code, StatementNode node) {
        code.append("\n").append(node.genCode());
    }

    private void addRawString(StringBuilder code, int count) {
        code.append("\n\t").append("_strTemplateBuilder").append(" += ").append("_rawStrList").append("[" + count + "]");
    }
}

