/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree;

import manifold.internal.runtime.Bootstrap;
import manifold.js.parser.tree.FunctionBodyNode;
import manifold.js.parser.tree.FunctionNode;
import manifold.js.parser.tree.ParameterNode;

public class ClassFunctionNode
extends FunctionNode {
    private String _className;
    private Boolean _isStatic = false;
    private Boolean _isOverride = false;
    private String _returnType = "dynamic.Dynamic";

    public ClassFunctionNode(String name) {
        super(name);
    }

    public ClassFunctionNode(String name, String className, boolean isStatic) {
        super(name);
        this._className = className;
        this._isStatic = isStatic;
    }

    public ClassFunctionNode(String name, String className) {
        super(name);
        this._className = className;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    public void setStatic(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public boolean isOverride() {
        return this._isOverride;
    }

    public void setOverride(boolean isOverride) {
        this._isOverride = isOverride;
    }

    @Override
    public void setReturnType(String returnType) {
        this._returnType = returnType;
    }

    @Override
    public String getReturnType() {
        return this._returnType;
    }

    @Override
    public String genCode() {
        String functionBodyCode;
        String parameterCode = this.getFirstChild(ParameterNode.class) == null ? "" : this.getFirstChild(ParameterNode.class).genCode();
        String string = functionBodyCode = this.getFirstChild(FunctionBodyNode.class) == null ? "{}" : this.getFirstChild(FunctionBodyNode.class).genCode();
        if (this.isOverride()) {
            return this.getName() + ": function(" + parameterCode + ")" + functionBodyCode;
        }
        return this._className + (this._isStatic != false ? "." : ".prototype.") + this.getName() + " = function(" + parameterCode + ")" + functionBodyCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ClassFunctionNode)) {
            return false;
        }
        ClassFunctionNode node = (ClassFunctionNode)obj;
        return this.getName().equals(node.getName()) && this._isStatic.booleanValue() == ((ClassFunctionNode)obj).isStatic();
    }

    static {
        Bootstrap.init();
    }
}

