/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import manifold.js.parser.tree.ClassFunctionNode;
import manifold.js.parser.tree.ConstructorNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.PropertyNode;

public class ClassNode
extends Node {
    private static final String CREATE_CLASS = "var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n";
    private static final String CLASS_CALL_CHECK = "function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\") } }\n";
    public static final String SUPERTYPE_OBJECT = "_superClassObject";
    private String _superClass = null;

    public ClassNode(String name) {
        super(name);
    }

    public ClassNode(String name, String superClass) {
        super(name);
        this._superClass = superClass;
    }

    public void setSuperClass(String superClass) {
        this._superClass = superClass;
    }

    public String getSuperClass() {
        return this._superClass;
    }

    @Override
    public String genCode() {
        StringBuilder code = new StringBuilder(CLASS_CALL_CHECK);
        if (!this.getChildren(PropertyNode.class).isEmpty()) {
            code.append(CREATE_CLASS);
        }
        code.append("var ").append(this.getName()).append(" = function(").append(this.getSuperClass() == null ? "" : "_" + this.getSuperClass()).append(") { ");
        String constructorCode = this.getChildren(ConstructorNode.class).isEmpty() ? "\n\t" + new ConstructorNode(this.getName()).genCode() : "\n\t" + this.getFirstChild(ConstructorNode.class).genCode();
        if (this.getSuperClass() != null) {
            StringBuilder superClassObjectCode = new StringBuilder();
            String superClassArg = "_" + this.getSuperClass();
            superClassObjectCode.append("\n\tvar ").append(SUPERTYPE_OBJECT).append("= new (Java.extend(").append(superClassArg).append("))(){").append(this.genOverrideFunctionCode(this.getChildren(ClassFunctionNode.class))).append("};");
            superClassObjectCode.append("\n\t").append("this.").append(SUPERTYPE_OBJECT).append(" = ").append(SUPERTYPE_OBJECT).append(";");
            constructorCode = constructorCode.replaceFirst("[{]", "{" + superClassObjectCode.toString());
        }
        code.append(constructorCode);
        if (this.getSuperClass() != null) {
            code.append("\n\t").append(this.getName()).append(".prototype._getSuperClass = function _getSuperClass(){return this._superClassObject}");
        }
        for (ClassFunctionNode node : this.getChildren(ClassFunctionNode.class)) {
            if (node.isOverride()) continue;
            code.append("\n\t").append(node.genCode());
        }
        code.append(this.genPropertyObjectCode(this.getChildren(PropertyNode.class)));
        code.append("\n\treturn " + this.getName() + ";\n}(").append(this.getSuperClass() == null ? "" : this.getSuperClass()).append(");");
        code.append("\n" + this.getName() + ";");
        return code.toString();
    }

    private String genOverrideFunctionCode(List<ClassFunctionNode> functionNodes) {
        return String.join((CharSequence)",", functionNodes.stream().filter(node -> node.isOverride()).map(node -> node.genCode()).collect(Collectors.toList()));
    }

    private String genPropertyObjectCode(List<PropertyNode> propertyNodes) {
        String propCode = "";
        if (!propertyNodes.isEmpty()) {
            class PropertyNodeWrapper {
                private String _name;
                private boolean _isStatic;
                private PropertyNode _getter = null;
                private PropertyNode _setter = null;

                public PropertyNodeWrapper(String name) {
                    this._name = name;
                }

                public void add(PropertyNode node) {
                    if (node.isSetter()) {
                        this._setter = node;
                    } else {
                        this._getter = node;
                    }
                }

                public String genCode() {
                    return "\n\t\t{key: \"" + this._name + "\"," + (this._setter != null ? this._setter.genCode() + "," : "") + (this._getter != null ? this._getter.genCode() : "") + "}";
                }
            }
            HashMap<String, PropertyNodeWrapper> propertyNodeBucket = new HashMap<String, PropertyNodeWrapper>();
            HashMap<String, PropertyNodeWrapper> staticPropertyNodeBucket = new HashMap<String, PropertyNodeWrapper>();
            propCode = propCode + "\n\t_createClass(" + this.getName() + ", ";
            for (PropertyNode node : propertyNodes) {
                PropertyNodeWrapper wrapper;
                if (node.isStatic()) {
                    wrapper = (PropertyNodeWrapper)staticPropertyNodeBucket.get(node.getName());
                    if (wrapper == null) {
                        wrapper = new PropertyNodeWrapper(node.getName());
                    }
                    staticPropertyNodeBucket.put(node.getName(), wrapper);
                } else {
                    wrapper = (PropertyNodeWrapper)propertyNodeBucket.get(node.getName());
                    if (wrapper == null) {
                        wrapper = new PropertyNodeWrapper(node.getName());
                    }
                    propertyNodeBucket.put(node.getName(), wrapper);
                }
                wrapper.add(node);
            }
            String nonStaticProps = propertyNodeBucket.isEmpty() ? "null" : "[" + String.join((CharSequence)",", propertyNodeBucket.values().stream().map(prop -> prop.genCode()).collect(Collectors.toList())) + "]";
            String staticProps = staticPropertyNodeBucket.isEmpty() ? "null" : "[" + String.join((CharSequence)",", staticPropertyNodeBucket.values().stream().map(prop -> prop.genCode()).collect(Collectors.toList())) + "]";
            propCode = propCode + nonStaticProps + "," + staticProps + ");";
        }
        return propCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassNode)) {
            return false;
        }
        ClassNode node = (ClassNode)obj;
        return this.getName().equals(node.getName()) && this.getSuperClass().equals(node.getSuperClass());
    }
}

