/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.io.InputStream;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.type.SourcePosition;
import manifold.internal.runtime.Bootstrap;
import manifold.js.JavascriptCodeGen;
import manifold.js.ThreadSafeBindings;
import manifold.js.Util;
import manifold.js.parser.Parser;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.FunctionNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParameterNode;
import manifold.js.parser.tree.ProgramNode;

public class JavascriptProgram {
    static SrcClass genProgram(String fqn, ProgramNode programNode) {
        SrcClass clazz = new SrcClass(fqn, SrcClass.Kind.Class).superClass(JavascriptProgram.class).imports(new Class[]{SourcePosition.class});
        clazz.addField(((SrcField)new SrcField("ENGINE", ScriptEngine.class).modifiers(8L)).initializer((SrcExpression)new SrcRawExpression("init(\"" + fqn + "\")")));
        clazz.addConstructor(((SrcConstructor)new SrcConstructor().modifiers(2L)).body(new SrcStatementBlock()));
        for (FunctionNode node : programNode.getChildren(FunctionNode.class)) {
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers(9L)).returns(node.getReturnType());
            ParameterNode firstChild = node.getFirstChild(ParameterNode.class);
            for (SrcParameter srcParameter : firstChild.toParamList()) {
                srcMethod.addParam(srcParameter);
            }
            srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return invoke(ENGINE, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(firstChild.toParamList()) + ");")));
            clazz.addMethod(srcMethod);
        }
        return clazz;
    }

    static String generateArgList(SrcParameter[] srcParameters) {
        StringBuilder sb = new StringBuilder();
        for (SrcParameter srcParameter : srcParameters) {
            sb.append(",");
            sb.append(srcParameter.getSimpleName());
        }
        return sb.toString();
    }

    public static <T> T invoke(ScriptEngine engine, String func, Object ... args) {
        try {
            return (T)((Invocable)((Object)engine)).invokeFunction(func, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptEngine init(String programName) {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        nashorn.setBindings(new ThreadSafeBindings(), 100);
        Parser parser = new Parser(new Tokenizer(JavascriptProgram.loadSrcForName(programName)));
        Node programNode = parser.parse();
        Util.safe(() -> nashorn.eval(programNode.genCode()));
        return nashorn;
    }

    static String loadSrcForName(String name) {
        String file = "/" + name.replace(".", "/") + ".js";
        InputStream resourceAsStream = JavascriptCodeGen.class.getResourceAsStream(file);
        return Util.loadContent(resourceAsStream);
    }

    static {
        Bootstrap.init();
    }
}

