/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import manifold.internal.runtime.Bootstrap;
import manifold.js.parser.Tokenizer;

public class Node {
    private String _name;
    Tokenizer.Token _start;
    Tokenizer.Token _end;
    List<Node> _children;

    public Node(String name) {
        this._name = name;
        this._children = new ArrayList<Node>();
    }

    public List<Node> getChildren() {
        return this._children;
    }

    public <T> List<T> getChildren(Class<T> clazz) {
        LinkedList<Node> lst = new LinkedList<Node>();
        for (Node child : this._children) {
            if (!child.getClass().equals(clazz)) continue;
            lst.add(child);
        }
        return lst;
    }

    public <T extends Node> T getFirstChild(Class<T> clazz) {
        for (Node child : this._children) {
            if (!child.getClass().equals(clazz)) continue;
            return (T)child;
        }
        return null;
    }

    public void addChild(Node n) {
        this._children.add(n);
    }

    public Node withChild(Node n) {
        this._children.add(n);
        return this;
    }

    public String getName() {
        return this._name;
    }

    public void setTokens(Tokenizer.Token start, Tokenizer.Token end) {
        this._start = start;
        this._end = end;
    }

    public Tokenizer.Token getStart() {
        return this._start;
    }

    public Tokenizer.Token getEnd() {
        return this._end;
    }

    public String genCode() {
        StringBuilder childCode = new StringBuilder();
        for (Node node : this.getChildren()) {
            childCode.append(node.genCode());
        }
        return childCode.toString();
    }

    public String toString() {
        return this.getName();
    }

    static {
        Bootstrap.init();
    }
}

