/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Objects;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcClass;
import manifold.internal.runtime.Bootstrap;
import manifold.js.JavascriptClass;
import manifold.js.JavascriptProgram;
import manifold.js.JavascriptTemplate;
import manifold.js.Util;
import manifold.js.parser.Parser;
import manifold.js.parser.TemplateParser;
import manifold.js.parser.TemplateTokenizer;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.ProgramNode;
import manifold.js.parser.tree.template.JSTNode;

public class JavascriptCodeGen {
    private final IFile _file;
    private final String _fqn;

    public JavascriptCodeGen(IFile file, String topLevelFqn) {
        this._file = file;
        this._fqn = topLevelFqn;
    }

    public SrcClass make() {
        if (Objects.equals(this._file.getExtension(), "jst")) {
            TemplateParser parser = new TemplateParser(new TemplateTokenizer(Util.loadContent(Util.safe(() -> ((IFile)this._file).openInputStream())), true));
            return JavascriptTemplate.genClass(this._fqn, (JSTNode)parser.parse());
        }
        Parser parser = new Parser(new Tokenizer(Util.loadContent(Util.safe(() -> ((IFile)this._file).openInputStream()))));
        ProgramNode programNode = (ProgramNode)parser.parse();
        if (programNode.errorCount() > 0) {
            programNode.printErrors();
        }
        if (parser.isES6Class()) {
            return JavascriptClass.genClass(this._fqn, programNode);
        }
        return JavascriptProgram.genProgram(this._fqn, programNode);
    }

    static {
        Bootstrap.init();
    }
}

