/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import manifold.internal.runtime.Bootstrap;
import manifold.js.parser.Token;
import manifold.js.parser.tree.ImportNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParseError;

public class ProgramNode
extends Node {
    private List<ParseError> _errorList;
    private URL _url;

    public ProgramNode(URL url) {
        super(null);
        this._url = url;
        this._errorList = new LinkedList<ParseError>();
    }

    public void addError(String msg, Token token) {
        this._errorList.add(new ParseError(msg, token));
    }

    @Override
    public ProgramNode getProgramNode() {
        return this;
    }

    public URL getUrl() {
        return this._url;
    }

    public int errorCount() {
        return this._errorList.size();
    }

    public List<ParseError> getErrorList() {
        return this._errorList;
    }

    public String getPackageFromClassName(String packageClass) {
        for (ImportNode node : this.getChildren(ImportNode.class)) {
            if (!node.getPackageClass().equals(packageClass)) continue;
            return node.getName();
        }
        return null;
    }

    @Override
    public String genCode() {
        String code = super.genCode();
        return code;
    }

    static {
        Bootstrap.init();
    }
}

