/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser.tree;

import java.util.LinkedList;
import manifold.internal.runtime.Bootstrap;
import manifold.js.parser.Token;
import manifold.js.parser.TokenType;
import manifold.js.parser.tree.Node;

public class FillerNode
extends Node {
    private LinkedList<Token> _tokens;
    private String _content;
    boolean _inOverrideFunction;

    public FillerNode() {
        super(null);
        this._tokens = new LinkedList();
    }

    public FillerNode(boolean inOverrideFunction) {
        super(null);
        this._tokens = new LinkedList();
        this._inOverrideFunction = inOverrideFunction;
    }

    public FillerNode(String content) {
        super(null);
        this._content = content;
    }

    public void concatToken(Token token) {
        this._tokens.add(token);
    }

    public Token removeLastToken() {
        return this._tokens.removeLast();
    }

    public Token removeLastNonWhitespaceToken() {
        Token toke = this._tokens.removeLast();
        while (toke.getType().equals((Object)TokenType.WHITESPACE)) {
            toke = this._tokens.removeLast();
        }
        return toke;
    }

    @Override
    public String genCode() {
        if (this._content != null) {
            return this._content;
        }
        StringBuilder code = new StringBuilder();
        for (Token token : this._tokens) {
            if (token.getType() == TokenType.KEYWORD && token.getValue().equals("super")) {
                code.append("Java.super(" + (this._inOverrideFunction ? "" : "this.") + "_superClassObject" + ")");
                continue;
            }
            code.append(token.getValue());
        }
        return code.toString();
    }

    static {
        Bootstrap.init();
    }
}

