/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.parser;

import manifold.internal.runtime.Bootstrap;
import manifold.js.parser.TokenType;

public class Token {
    private int _lineNumber;
    private int _col;
    private int _offset;
    private TokenType _type;
    private String _val;
    private String _errorMsg;

    public Token(TokenType type, String val) {
        this._type = type;
        this._val = val;
    }

    public Token(TokenType type, String val, String errorMsg) {
        this._type = type;
        this._val = val;
        this._errorMsg = errorMsg;
    }

    public Token(TokenType type, String val, int lineNumber, int col, int offset) {
        this._type = type;
        this._val = val;
        this._lineNumber = lineNumber;
        this._col = col;
        this._offset = offset;
    }

    public TokenType getType() {
        return this._type;
    }

    public String getValue() {
        return this._val;
    }

    public String getErrorMsg() {
        return this._errorMsg;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        Token token = (Token)obj;
        return this._type == token.getType() && this._val.equals(token.getValue());
    }

    public String toString() {
        return String.format("type: %s val: %s pos: %d:%d:%d\n", new Object[]{this._type, this._val, this._lineNumber, this._col, this._offset});
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getCol() {
        return this._col;
    }

    static {
        Bootstrap.init();
    }
}

