/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Collections;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import manifold.api.fs.IFile;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.type.ITypeManifold;
import manifold.api.type.SourcePosition;
import manifold.internal.host.ManifoldHost;
import manifold.internal.runtime.Bootstrap;
import manifold.js.ThreadSafeBindings;
import manifold.js.Util;
import manifold.js.parser.Parser;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.FunctionNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParameterNode;
import manifold.js.parser.tree.ProgramNode;

public class JavascriptProgram {
    static SrcClass genProgram(String fqn, ProgramNode programNode) {
        SrcClass clazz = new SrcClass(fqn, SrcClass.Kind.Class).superClass(JavascriptProgram.class).imports(new Class[]{SourcePosition.class});
        clazz.addField(((SrcField)new SrcField("ENGINE", ScriptEngine.class).modifiers(8L)).initializer((SrcExpression)new SrcRawExpression("init(\"" + fqn + "\")")));
        clazz.addConstructor(((SrcConstructor)new SrcConstructor().modifiers(2L)).body(new SrcStatementBlock()));
        for (FunctionNode node : programNode.getChildren(FunctionNode.class)) {
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers(9L)).returns(node.getReturnType());
            List<SrcParameter> srcParameters = JavascriptProgram.makeSrcParameters(node, (SrcAnnotated)srcMethod);
            srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return invoke(ENGINE, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(srcParameters) + ");")));
            clazz.addMethod(srcMethod);
        }
        return clazz;
    }

    static List<SrcParameter> makeSrcParameters(Node node, SrcAnnotated srcMethod) {
        ParameterNode paramNode = node.getFirstChild(ParameterNode.class);
        List<Object> srcParameters = paramNode != null ? paramNode.toParamList() : Collections.emptyList();
        for (SrcParameter srcParameter : srcParameters) {
            srcMethod.addParam(srcParameter);
        }
        return srcParameters;
    }

    static String generateArgList(List<SrcParameter> srcParameters) {
        StringBuilder sb = new StringBuilder();
        for (SrcParameter srcParameter : srcParameters) {
            sb.append(",");
            sb.append(srcParameter.getSimpleName());
        }
        return sb.toString();
    }

    public static <T> T invoke(ScriptEngine engine, String func, Object ... args) {
        try {
            return (T)((Invocable)((Object)engine)).invokeFunction(func, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptEngine init(String programName) {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        nashorn.setBindings(new ThreadSafeBindings(), 100);
        Parser parser = new Parser(new Tokenizer(JavascriptProgram.loadSrcForName(programName, "js")));
        Node programNode = parser.parse();
        Util.safe(() -> nashorn.eval(programNode.genCode()));
        return nashorn;
    }

    static IFile loadSrcForName(String fqn, String fileExt) {
        List filesForType = JavascriptProgram.findJavascriptManifold(fileExt).findFilesForType(fqn);
        if (filesForType.isEmpty()) {
            throw new IllegalStateException("Could not find a ." + fileExt + " file for type: " + fqn);
        }
        if (filesForType.size() > 1) {
            System.err.println("===\nWARNING: more than one ." + fileExt + " file corresponds with type: '" + fqn + "':\n");
            filesForType.forEach(file -> System.err.println(file.toString()));
            System.err.println("using the first one: " + filesForType.get(0) + "\n===");
        }
        return (IFile)filesForType.get(0);
    }

    private static ITypeManifold findJavascriptManifold(String fileExt) {
        ITypeManifold tm = ManifoldHost.instance().getCurrentModule().getTypeManifolds().stream().filter(e -> e.handlesFileExtension(fileExt)).findFirst().orElse(null);
        if (tm == null) {
            throw new IllegalStateException("Could not find type manifold for extension: " + fileExt);
        }
        return tm;
    }

    static {
        Bootstrap.init();
    }
}

