/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.type.SourcePosition;
import manifold.internal.runtime.Bootstrap;
import manifold.js.JavascriptProgram;
import manifold.js.ThreadSafeBindings;
import manifold.js.parser.Parser;
import manifold.js.parser.Tokenizer;
import manifold.js.parser.tree.ClassFunctionNode;
import manifold.js.parser.tree.ClassNode;
import manifold.js.parser.tree.ConstructorNode;
import manifold.js.parser.tree.Node;
import manifold.js.parser.tree.ParameterNode;
import manifold.js.parser.tree.ProgramNode;
import manifold.js.parser.tree.PropertyNode;
import manifold.util.ManClassUtil;

public class JavascriptClass {
    private static ThreadLocal<Long> uid;

    static SrcClass genClass(String fqn, ProgramNode programNode) {
        ClassNode classNode = programNode.getFirstChild(ClassNode.class);
        SrcClass clazz = new SrcClass(fqn, SrcClass.Kind.Class);
        clazz.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)programNode.getUrl().toString()).addArgument("feature", String.class, (Object)ManClassUtil.getShortClassName((String)fqn)).addArgument("offset", Integer.TYPE, (Object)classNode.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(classNode.getEnd().getOffset() - classNode.getStart().getOffset())));
        String superClass = classNode.getSuperClass();
        if (superClass != null) {
            clazz.superClass(superClass);
        }
        clazz.imports(new Class[]{JavascriptClass.class}).imports(new Class[]{SourcePosition.class});
        clazz.addField(((SrcField)new SrcField("ENGINE", ScriptEngine.class).modifiers(74L)).initializer((SrcExpression)new SrcRawExpression("null")));
        clazz.addField(((SrcField)new SrcField("TIMESTAMP", Long.TYPE).modifiers(74L)).initializer((SrcExpression)new SrcRawExpression("0")));
        clazz.addField(new SrcField("_context", ScriptObjectMirror.class));
        JavascriptClass.addConstructor(clazz, classNode);
        JavascriptClass.addUtilityMethods(clazz, classNode, fqn);
        JavascriptClass.addMethods(fqn, clazz, classNode);
        JavascriptClass.addProperties(fqn, clazz, classNode);
        return clazz;
    }

    private static void addConstructor(SrcClass clazz, ClassNode classNode) {
        List<SrcParameter> srcParameters;
        ConstructorNode constructor = classNode.getFirstChild(ConstructorNode.class);
        SrcConstructor ctor = (SrcConstructor)((SrcConstructor)new SrcConstructor().name(classNode.getName())).modifiers(1L);
        if (constructor != null) {
            srcParameters = JavascriptProgram.makeSrcParameters(constructor, (SrcAnnotated)ctor);
            ctor.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)"constructor").addArgument("offset", Integer.TYPE, (Object)constructor.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(constructor.getEnd().getOffset() - constructor.getStart().getOffset())));
        } else {
            srcParameters = Collections.emptyList();
        }
        ctor.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("_context = JavascriptClass.initInstance(getEngine(), \"" + classNode.getName() + "\"" + JavascriptProgram.generateArgList(srcParameters) + ");")));
        clazz.addConstructor(ctor);
    }

    private static void addUtilityMethods(SrcClass clazz, ClassNode classNode, String fqn) {
        long timestamp = JavascriptClass.incUid();
        SrcMethod m = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("getEngine")).modifiers(10L)).returns(ScriptEngine.class)).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("if( " + timestamp + "L != TIMESTAMP ) {\n      synchronized( " + classNode.getName() + ".class ) {\n        if( " + timestamp + "L != TIMESTAMP ) {\n          TIMESTAMP = " + timestamp + "L;\n          ENGINE = JavascriptClass.init(\"" + fqn + "\");\n        }\n      }\n    }\n    return ENGINE;")));
        clazz.addMethod((AbstractSrcMethod)m);
    }

    private static long incUid() {
        Long id = uid.get();
        if (id == null) {
            id = 1L;
            uid.set(id);
        }
        id = id + 1L;
        uid.set(id);
        return id;
    }

    private static void addMethods(String fqn, SrcClass clazz, ClassNode classNode) {
        for (ClassFunctionNode node : classNode.getChildren(ClassFunctionNode.class)) {
            AbstractSrcMethod srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers((long)(1 | (node.isStatic() ? 8 : 0)))).returns(node.getReturnType());
            srcMethod.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)node.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
            ParameterNode parameters = node.getFirstChild(ParameterNode.class);
            for (SrcParameter srcParameter : parameters.toParamList()) {
                srcMethod.addParam(srcParameter);
            }
            if (node.isStatic()) {
                srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return JavascriptClass.invokeStatic(getEngine(), \"" + ManClassUtil.getShortClassName((String)fqn) + "\", \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(parameters.toParamList()) + ");")));
            } else {
                srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return JavascriptClass.invoke(_context, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(parameters.toParamList()) + ");")));
            }
            clazz.addMethod(srcMethod);
        }
    }

    private static void addProperties(String fqn, SrcClass clazz, ClassNode classNode) {
        for (PropertyNode node : classNode.getChildren(PropertyNode.class)) {
            String name = node.getName();
            String capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
            if (node.isSetter()) {
                AbstractSrcMethod setter = ((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("set" + capitalizedName)).modifiers((long)(1 | (node.isStatic() ? 8 : 0)))).addParam("val", Object.class)).returns("void");
                setter.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)node.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
                if (node.isStatic()) {
                    setter.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("JavascriptClass.setStaticProp(getEngine(), \"" + ManClassUtil.getShortClassName((String)fqn) + "\", \"" + name + "\", val);")));
                } else {
                    setter.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("JavascriptClass.setProp(_context, \"" + name + "\", val);")));
                }
                clazz.addMethod(setter);
                continue;
            }
            AbstractSrcMethod getter = ((SrcMethod)((SrcMethod)new SrcMethod().name("get" + capitalizedName)).modifiers((long)(1 | (node.isStatic() ? 8 : 0)))).returns(node.getReturnType());
            getter.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)node.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
            if (node.isStatic()) {
                getter.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return JavascriptClass.getStaticProp(getEngine(), \"" + ManClassUtil.getShortClassName((String)fqn) + "\", \"" + name + "\");")));
            } else {
                getter.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return JavascriptClass.getProp(_context, \"" + name + "\");")));
            }
            clazz.addMethod(getter);
        }
    }

    public static <T> T invoke(ScriptObjectMirror context, String func, Object ... args) {
        return (T)context.callMember(func, args);
    }

    public static <T> T invokeStatic(ScriptEngine engine, String className, String func, Object ... args) {
        ScriptObjectMirror classObject = JavascriptClass.getClassObject(engine, className);
        return (T)classObject.callMember(func, args);
    }

    public static Object getProp(ScriptObjectMirror context, String prop) {
        return context.get((Object)prop);
    }

    public static Object getStaticProp(ScriptEngine engine, String className, String property) {
        ScriptObjectMirror classObject = JavascriptClass.getClassObject(engine, className);
        return classObject.get((Object)property);
    }

    public static void setProp(ScriptObjectMirror context, String prop, Object value) {
        context.setMember(prop, value);
    }

    public static void setStaticProp(ScriptEngine engine, String className, String property, Object value) {
        ScriptObjectMirror classObject = JavascriptClass.getClassObject(engine, className);
        classObject.put("_" + property, value);
    }

    public static ScriptEngine init(String programName) {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        nashorn.setBindings(new ThreadSafeBindings(), 100);
        Parser parser = new Parser(new Tokenizer(JavascriptProgram.loadSrcForName(programName, "js")));
        Node programNode = parser.parse();
        ClassNode classNode = programNode.getFirstChild(ClassNode.class);
        String script = classNode.genCode();
        try {
            nashorn.eval(script);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return nashorn;
    }

    public static ScriptObjectMirror initInstance(ScriptEngine engine, String name, Object ... args) {
        ScriptObjectMirror classObject = JavascriptClass.getClassObject(engine, name);
        return (ScriptObjectMirror)classObject.newObject(args);
    }

    private static ScriptObjectMirror getClassObject(ScriptEngine engine, String name) {
        return (ScriptObjectMirror)((ScriptObjectMirror)engine.get("nashorn.global")).get((Object)name);
    }

    static {
        Bootstrap.init();
        uid = new ThreadLocal();
    }
}

