/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.rt;

import manifold.js.rt.SharedScope;
import manifold.js.rt.parser.Parser;
import manifold.js.rt.parser.TemplateParser;
import manifold.js.rt.parser.TemplateTokenizer;
import manifold.js.rt.parser.Tokenizer;
import manifold.js.rt.parser.tree.ClassNode;
import manifold.js.rt.parser.tree.Node;
import manifold.js.rt.parser.tree.template.JSTNode;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsRuntime {
    private static ThreadLocal<Integer> _programCounter = ThreadLocal.withInitial(() -> 0);
    private static ThreadLocal<Integer> _Templatecounter = ThreadLocal.withInitial(() -> 0);

    public static <T> T invoke(ScriptableObject scope, String func, Object ... args) {
        return (T)ScriptableObject.callMethod((Scriptable)scope, (String)func, (Object[])args);
    }

    public static <T> T invokeStatic(ScriptableObject scope, String className, String func, Object ... args) {
        return (T)ScriptableObject.callMethod((Scriptable)((Scriptable)scope.get(className, (Scriptable)scope)), (String)func, (Object[])args);
    }

    public static Object getProp(ScriptableObject scope, String prop) {
        return ScriptableObject.getProperty((Scriptable)scope, (String)prop);
    }

    public static Object getStaticProp(ScriptableObject scope, String className, String prop) {
        return ScriptableObject.getProperty((Scriptable)((Scriptable)scope.get(className, (Scriptable)scope)), (String)prop);
    }

    public static void setProp(ScriptableObject scope, String prop, Object value) {
        ScriptableObject.putProperty((Scriptable)scope, (String)prop, (Object)value);
    }

    public static void setStaticProp(ScriptableObject scope, String className, String prop, Object value) {
        ScriptableObject.putProperty((Scriptable)((Scriptable)scope.get(className, (Scriptable)scope)), (String)prop, (Object)value);
    }

    public static ScriptableObject init(String fqn, String content, String url) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(content, url));
        Node programNode = parser.parse();
        ClassNode classNode = programNode.getFirstChild(ClassNode.class);
        String script = classNode.genCode();
        Context.getCurrentContext().evaluateString((Scriptable)scope, script, fqn, 1, null);
        return scope;
    }

    public static ScriptableObject initInstance(ScriptableObject scope, String name, Object ... args) {
        return (ScriptableObject)Context.getCurrentContext().newObject((Scriptable)scope, name, args);
    }

    public static <T> T invokeProg(ScriptableObject scope, String func, Object ... args) {
        try {
            Function renderToString = (Function)scope.get(func, (Scriptable)scope);
            return (T)renderToString.call(Context.getCurrentContext(), (Scriptable)scope, (Scriptable)scope, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScriptableObject initProg(String fqn, String source, String url) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(source, url));
        Node programNode = parser.parse();
        Context.getCurrentContext().evaluateString((Scriptable)scope, programNode.genCode(), fqn, 1, null);
        return scope;
    }

    public static ScriptableObject initDirect(String source, String url) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(source, url));
        Node programNode = parser.parse();
        Context.getCurrentContext().evaluateString((Scriptable)scope, programNode.genCode(), "direct_" + _programCounter.get(), 1, null);
        _programCounter.set(_programCounter.get() + 1);
        return scope;
    }

    public static Object evaluate(String source, String url) {
        ScriptableObject scope = SharedScope.newStaticScope();
        Parser parser = new Parser(new Tokenizer(source, url));
        Node programNode = parser.parse();
        return Context.getCurrentContext().evaluateString((Scriptable)scope, programNode.genCode(), "evaluate_js", 1, null);
    }

    public static ScriptableObject initEngine(JSTNode templateNode) {
        ScriptableObject scope = SharedScope.newStaticScope();
        String name = "template_" + _Templatecounter.get();
        _Templatecounter.set(_Templatecounter.get() + 1);
        Context.getCurrentContext().evaluateString((Scriptable)scope, templateNode.genCode(), name, 1, null);
        return scope;
    }

    public static JSTNode initNode(String fqn, String source, String url) {
        TemplateParser parser = new TemplateParser(new TemplateTokenizer(fqn, source, url, true));
        return (JSTNode)parser.parse();
    }
}

