/*
 * Decompiled with CFR 0.152.
 */
package manifold.javadoc.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import manifold.javadoc.agent.org.objectweb.asm.ClassReader;
import manifold.javadoc.agent.org.objectweb.asm.ClassVisitor;
import manifold.javadoc.agent.org.objectweb.asm.ClassWriter;
import manifold.javadoc.agent.org.objectweb.asm.MethodVisitor;
import manifold.javadoc.agent.org.objectweb.asm.Type;

public class Agent {
    private static final int Java_Version = Agent.getJavaVersion();
    private static final String JavadocTool_class = Java_Version == 8 ? "com/sun/tools/javadoc/JavadocTool" : "jdk/javadoc/internal/tool/JavadocTool";

    public static void premain(String args, Instrumentation instrumentation) {
        instrumentation.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String name, Class<?> cls, ProtectionDomain pd, byte[] bytes) {
                if (JavadocTool_class.equals(name)) {
                    ClassReader reader = new ClassReader(bytes);
                    ClassWriter writer = new ClassWriter(reader, 0);
                    JavacPluginAdder visitor = new JavacPluginAdder(writer);
                    reader.accept(visitor, 0);
                    return writer.toByteArray();
                }
                return null;
            }
        });
    }

    private static int getJavaVersion() {
        char c;
        String version = System.getProperty("java.version");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < version.length() && Character.isDigit(c = version.charAt(i)); ++i) {
            sb.append(c);
        }
        int major = Integer.parseInt(sb.toString());
        major = major <= 1 ? 8 : major;
        return major;
    }

    private static class JavacPluginAdder
    extends ClassVisitor {
        public JavacPluginAdder(ClassWriter writer) {
            super(589824, writer);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals(Java_Version == 8 ? "getRootDocImpl" : "getEnvironment")) {
                return new MethodVisitor(589824, mv){

                    @Override
                    public void visitCode() {
                        this.visitVarInsn(25, 0);
                        this.visitFieldInsn(180, JavadocTool_class, "context", "Lcom/sun/tools/javac/util/Context;");
                        this.mv.visitVarInsn(25, 0);
                        this.mv.visitFieldInsn(180, JavadocTool_class, "context", "Lcom/sun/tools/javac/util/Context;");
                        this.mv.visitLdcInsn(Type.getType("Ljavax/tools/JavaFileManager;"));
                        this.mv.visitMethodInsn(182, "com/sun/tools/javac/util/Context", "get", "(Ljava/lang/Class;)Ljava/lang/Object;", false);
                        this.mv.visitTypeInsn(192, "javax/tools/JavaFileManager");
                        this.mv.visitFieldInsn(178, "javax/tools/StandardLocation", "CLASS_PATH", "Ljavax/tools/StandardLocation;");
                        this.mv.visitMethodInsn(185, "javax/tools/JavaFileManager", "getClassLoader", "(Ljavax/tools/JavaFileManager$Location;)Ljava/lang/ClassLoader;", true);
                        this.visitMethodInsn(184, "manifold/javadoc/agent/Util", "initJavacPlugin", "(Lcom/sun/tools/javac/util/Context;Ljava/lang/ClassLoader;)V", false);
                        super.visitCode();
                    }
                };
            }
            return mv;
        }
    }
}

