/*
 * Decompiled with CFR 0.152.
 */
package manifold.io;

import java.io.File;
import java.util.List;
import manifold.collections.extensions.java.lang.Iterable.ManIterableExt;
import manifold.io.extensions.java.io.File.ManFileExt;

public class FilePathComponents {
    public final File root;
    public final List<File> segments;

    public FilePathComponents(File root, List<File> segments) {
        this.root = root;
        this.segments = segments;
    }

    public String rootName() {
        return this.root.getPath();
    }

    public boolean isRooted() {
        return !this.root.getPath().isEmpty();
    }

    public int size() {
        return this.segments.size();
    }

    public File subPath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > this.size()) {
            throw new IllegalArgumentException();
        }
        return new File(ManIterableExt.joinToString(this.segments.subList(beginIndex, endIndex), (CharSequence)File.separator));
    }

    public FilePathComponents normalize() {
        return new FilePathComponents(this.root, ManFileExt.normalize(this.segments));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePathComponents that = (FilePathComponents)o;
        if (!this.root.equals(that.root)) {
            return false;
        }
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int result = this.root.hashCode();
        result = 31 * result + this.segments.hashCode();
        return result;
    }
}

