/*
 * Decompiled with CFR 0.152.
 */
package manifold.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.api.util.AbstractIterator;
import manifold.api.util.Stack;

public class FileTreeWalk
implements Iterable<File> {
    private final File _start;
    private final FileWalkDirection _direction;
    private final Function<File, Boolean> _onEnter;
    private final Consumer<File> _onLeave;
    private final BiConsumer<File, IOException> _onFail;
    private final int _maxDepth;

    public FileTreeWalk(File start, FileWalkDirection direction, Function<File, Boolean> onEnter, Consumer<File> onLeave, BiConsumer<File, IOException> onFail, int maxDepth) {
        this._start = start;
        this._direction = direction;
        this._onEnter = onEnter;
        this._onLeave = onLeave;
        this._onFail = onFail;
        this._maxDepth = maxDepth;
    }

    public FileTreeWalk(File start, FileWalkDirection direction) {
        this(start, direction, null, null, null, Integer.MAX_VALUE);
    }

    public FileTreeWalk(File start) {
        this(start, FileWalkDirection.TOP_DOWN);
    }

    @Override
    public Iterator<File> iterator() {
        return new FileTreeWalkIterator();
    }

    public FileTreeWalk onEnter(Function<File, Boolean> function) {
        return new FileTreeWalk(this._start, this._direction, function, this._onLeave, this._onFail, this._maxDepth);
    }

    public FileTreeWalk onLeave(Consumer<File> function) {
        return new FileTreeWalk(this._start, this._direction, this._onEnter, function, this._onFail, this._maxDepth);
    }

    public FileTreeWalk onFail(BiConsumer<File, IOException> function) {
        return new FileTreeWalk(this._start, this._direction, this._onEnter, this._onLeave, function, this._maxDepth);
    }

    public FileTreeWalk maxDepth(int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException("depth must be positive, but was " + depth + ".");
        }
        return new FileTreeWalk(this._start, this._direction, this._onEnter, this._onLeave, this._onFail, depth);
    }

    public static enum FileWalkDirection {
        TOP_DOWN,
        BOTTOM_UP;

    }

    private class FileTreeWalkIterator
    extends AbstractIterator<File> {
        private Stack<WalkState> state = new Stack();

        FileTreeWalkIterator() {
            if (FileTreeWalk.this._start.isDirectory()) {
                this.state.push((Object)this.directoryState(FileTreeWalk.this._start));
            } else if (FileTreeWalk.this._start.isFile()) {
                this.state.push((Object)new SingleFileState(FileTreeWalk.this._start));
            } else {
                this.done();
            }
        }

        public void computeNext() {
            File nextFile = this.gotoNext();
            if (nextFile != null) {
                this.setNext(nextFile);
            } else {
                this.done();
            }
        }

        private DirectoryState directoryState(File root) {
            return FileTreeWalk.this._direction == FileWalkDirection.TOP_DOWN ? new TopDownDirectoryState(root) : new BottomUpDirectoryState(root);
        }

        private File gotoNext() {
            if (this.state.isEmpty()) {
                return null;
            }
            WalkState topState = (WalkState)this.state.peek();
            File file = topState.step();
            if (file == null) {
                this.state.pop();
                return this.gotoNext();
            }
            if (file == topState.root || !file.isDirectory() || this.state.size() >= FileTreeWalk.this._maxDepth) {
                return file;
            }
            this.state.push((Object)this.directoryState(file));
            return this.gotoNext();
        }

        private class SingleFileState
        extends WalkState {
            private boolean visited;

            SingleFileState(File root) {
                super(root);
            }

            @Override
            public File step() {
                if (this.visited) {
                    return null;
                }
                this.visited = true;
                return this.root;
            }
        }

        private class TopDownDirectoryState
        extends DirectoryState {
            private boolean rootVisited;
            private File[] fileList;
            private int fileIndex;

            TopDownDirectoryState(File rootDir) {
                super(rootDir);
            }

            @Override
            public File step() {
                if (!this.rootVisited) {
                    if (FileTreeWalk.this._onEnter != null && !((Boolean)FileTreeWalk.this._onEnter.apply(this.root)).booleanValue()) {
                        return null;
                    }
                    this.rootVisited = true;
                    return this.root;
                }
                if (this.fileList == null || this.fileIndex < this.fileList.length) {
                    if (this.fileList == null) {
                        this.fileList = this.root.listFiles();
                        if (this.fileList == null && FileTreeWalk.this._onFail != null) {
                            FileTreeWalk.this._onFail.accept(this.root, new AccessDeniedException(this.root.toString(), null, "Cannot list files in a directory"));
                        }
                        if (this.fileList == null || this.fileList.length == 0) {
                            if (FileTreeWalk.this._onLeave != null) {
                                FileTreeWalk.this._onLeave.accept(this.root);
                            }
                            return null;
                        }
                    }
                    return this.fileList[this.fileIndex++];
                }
                if (FileTreeWalk.this._onLeave != null) {
                    FileTreeWalk.this._onLeave.accept(this.root);
                }
                return null;
            }
        }

        private class BottomUpDirectoryState
        extends DirectoryState {
            private boolean rootVisited;
            private File[] fileList;
            private int fileIndex;
            private boolean failed;

            BottomUpDirectoryState(File rootDir) {
                super(rootDir);
            }

            @Override
            public File step() {
                if (!this.failed && this.fileList == null) {
                    if (FileTreeWalk.this._onEnter != null && !((Boolean)FileTreeWalk.this._onEnter.apply(this.root)).booleanValue()) {
                        return null;
                    }
                    this.fileList = this.root.listFiles();
                    if (this.fileList == null) {
                        if (FileTreeWalk.this._onFail != null) {
                            FileTreeWalk.this._onFail.accept(this.root, new AccessDeniedException(this.root.toString(), null, "Cannot list files in a directory"));
                        }
                        this.failed = true;
                    }
                }
                if (this.fileList != null && this.fileIndex < this.fileList.length) {
                    return this.fileList[this.fileIndex++];
                }
                if (!this.rootVisited) {
                    this.rootVisited = true;
                    return this.root;
                }
                if (FileTreeWalk.this._onLeave != null) {
                    FileTreeWalk.this._onLeave.accept(this.root);
                }
                return null;
            }
        }
    }

    private abstract class DirectoryState
    extends WalkState {
        private File rootDir;

        DirectoryState(File rootDir) {
            super(rootDir);
            this.rootDir = rootDir;
        }
    }

    private abstract class WalkState {
        final File root;

        WalkState(File root) {
            this.root = root;
        }

        public abstract File step();
    }
}

