/*
 * Decompiled with CFR 0.152.
 */
package manifold.io.extensions.java.io.BufferedReader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.internal.runtime.Bootstrap;

@Extension
public class ManBufferedReaderExt {
    public static Iterable<String> lineSequence(@This BufferedReader thiz) {
        return new LinesSequence(thiz);
    }

    static {
        Bootstrap.init();
    }

    private static class LinesSequence
    implements Iterable<String> {
        private final BufferedReader _reader;

        LinesSequence(BufferedReader reader) {
            this._reader = reader;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private String nextValue;
                private boolean done;

                @Override
                public boolean hasNext() {
                    if (this.nextValue == null && !this.done) {
                        try {
                            this.nextValue = _reader.readLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        if (this.nextValue == null) {
                            this.done = true;
                        }
                    }
                    return this.nextValue != null;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String answer = this.nextValue;
                    this.nextValue = null;
                    return answer;
                }
            };
        }

        static {
            Bootstrap.init();
        }
    }
}

