/*
 * Decompiled with CFR 0.152.
 */
package manifold.io.extensions.java.io.File;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.io.extensions.java.io.BufferedReader.ManBufferedReaderExt;
import manifold.io.extensions.java.io.InputStream.ManInputStreamExt;
import manifold.io.extensions.java.io.OutputStream.ManOutputStreamExt;
import manifold.io.extensions.java.io.Reader.ManReaderExt;
import manifold.io.extensions.java.io.Writer.ManWriterExt;

@Extension
public class ManFileReadWriteExt {
    private static final int DEFAULT_BLOCK_SIZE = 4096;

    public static InputStreamReader reader(@This File thiz) {
        return ManFileReadWriteExt.reader(thiz, StandardCharsets.UTF_8);
    }

    public static InputStreamReader reader(@This File thiz, Charset charset) {
        return ManInputStreamExt.reader(ManFileReadWriteExt.inputStream(thiz), charset);
    }

    public static BufferedReader bufferedReader(@This File thiz) {
        return ManFileReadWriteExt.bufferedReader(thiz, StandardCharsets.UTF_8, 8192);
    }

    public static BufferedReader bufferedReader(@This File thiz, Charset charset, int bufferSize) {
        return ManReaderExt.buffered(ManFileReadWriteExt.reader(thiz, charset), bufferSize);
    }

    public static OutputStreamWriter writer(@This File thiz) {
        return ManFileReadWriteExt.writer(thiz, StandardCharsets.UTF_8);
    }

    public static OutputStreamWriter writer(@This File thiz, Charset charset) {
        return ManOutputStreamExt.writer(ManFileReadWriteExt.outputStream(thiz), charset);
    }

    public static BufferedWriter bufferedWriter(@This File thiz) {
        return ManFileReadWriteExt.bufferedWriter(thiz, StandardCharsets.UTF_8, 8192);
    }

    public static BufferedWriter bufferedWriter(@This File thiz, Charset charset, int bufferSize) {
        return ManWriterExt.buffered(ManFileReadWriteExt.writer(thiz, charset), bufferSize);
    }

    public static PrintWriter printWriter(@This File thiz) {
        return ManFileReadWriteExt.printWriter(thiz, StandardCharsets.UTF_8);
    }

    public static PrintWriter printWriter(@This File thiz, Charset charset) {
        return new PrintWriter(ManFileReadWriteExt.bufferedWriter(thiz, charset, 8192));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(@This File thiz) {
        try (FileInputStream input = new FileInputStream(thiz);){
            int count;
            long remaining;
            int offset = 0;
            if (remaining > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("File " + thiz + " is too big (" + remaining + " bytes) to fit in memory.");
            }
            byte[] result = new byte[(int)remaining];
            for (remaining = thiz.length(); remaining > 0L && (count = input.read(result, offset, (int)remaining)) >= 0; remaining -= (long)count, offset += count) {
            }
            if (remaining != 0L) {
                byte[] copy = new byte[offset];
                System.arraycopy(result, 0, copy, 0, offset);
                result = copy;
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBytes(@This File thiz, byte[] array) {
        try (FileOutputStream it = new FileOutputStream(thiz);){
            it.write(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendBytes(@This File thiz, byte[] array) {
        try (FileOutputStream it = new FileOutputStream(thiz, true);){
            it.write(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readText(@This File thiz) {
        return ManFileReadWriteExt.readText(thiz, StandardCharsets.UTF_8);
    }

    public static String readText(@This File thiz, Charset charset) {
        return new String(ManFileReadWriteExt.readBytes(thiz), charset);
    }

    public static void writeText(@This File thiz, String text) {
        ManFileReadWriteExt.writeText(thiz, text, StandardCharsets.UTF_8);
    }

    public static void writeText(@This File thiz, String text, Charset charset) {
        ManFileReadWriteExt.writeBytes(thiz, text.getBytes(charset));
    }

    public static void appendText(@This File thiz, String text) {
        ManFileReadWriteExt.appendText(thiz, text, StandardCharsets.UTF_8);
    }

    public static void appendText(@This File thiz, String text, Charset charset) {
        ManFileReadWriteExt.appendBytes(thiz, text.getBytes(charset));
    }

    public static void forEachBlock(@This File thiz, BiConsumer<byte[], Integer> action) {
        ManFileReadWriteExt.forEachBlock(thiz, 4096, action);
    }

    public static void forEachBlock(@This File thiz, int blockSize, BiConsumer<byte[], Integer> action) {
        byte[] arr = new byte[blockSize];
        try (FileInputStream fis = new FileInputStream(thiz);){
            int size;
            while ((size = fis.read(arr)) > 0) {
                action.accept(arr, size);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void forEachLine(@This File thiz, Charset charset, Consumer<String> action) {
        try {
            ManReaderExt.forEachLine(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(thiz), charset)), action);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileInputStream inputStream(@This File thiz) {
        try {
            return new FileInputStream(thiz);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileOutputStream outputStream(@This File thiz) {
        try {
            return new FileOutputStream(thiz);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readLines(@This File thiz, Charset charset) {
        ArrayList<String> result = new ArrayList<String>();
        ManFileReadWriteExt.forEachLine(thiz, charset, it -> result.add((String)it));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T useLines(@This File thiz, Charset charset, Function<Iterable<String>, T> block) {
        try (BufferedReader it = ManFileReadWriteExt.bufferedReader(thiz, charset, 8192);){
            Iterable<String> iterable = block.apply(ManBufferedReaderExt.lineSequence(it));
            return (T)iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

