/*
 * Decompiled with CFR 0.152.
 */
package manifold.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.util.AbstractIterator;
import manifold.util.Stack;

public class FileTreeWalk
implements Iterable<File> {
    private final File start;
    private final FileWalkDirection direction;
    private final Function<File, Boolean> onEnter;
    private final Consumer<File> onLeave;
    private final BiConsumer<File, IOException> onFail;
    private final int maxDepth;

    public FileTreeWalk(File start, FileWalkDirection direction, Function<File, Boolean> onEnter, Consumer<File> onLeave, BiConsumer<File, IOException> onFail, int maxDepth) {
        this.start = start;
        this.direction = direction;
        this.onEnter = onEnter;
        this.onLeave = onLeave;
        this.onFail = onFail;
        this.maxDepth = maxDepth;
    }

    public FileTreeWalk(File start, FileWalkDirection direction) {
        this(start, direction, null, null, null, Integer.MAX_VALUE);
    }

    public FileTreeWalk(File start) {
        this(start, FileWalkDirection.TOP_DOWN);
    }

    @Override
    public Iterator<File> iterator() {
        return new FileTreeWalkIterator();
    }

    public FileTreeWalk onEnter(Function<File, Boolean> function) {
        return new FileTreeWalk(this.start, this.direction, function, this.onLeave, this.onFail, this.maxDepth);
    }

    public FileTreeWalk onLeave(Consumer<File> function) {
        return new FileTreeWalk(this.start, this.direction, this.onEnter, function, this.onFail, this.maxDepth);
    }

    public FileTreeWalk onFail(BiConsumer<File, IOException> function) {
        return new FileTreeWalk(this.start, this.direction, this.onEnter, this.onLeave, function, this.maxDepth);
    }

    public FileTreeWalk maxDepth(int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException("depth must be positive, but was " + depth + ".");
        }
        return new FileTreeWalk(this.start, this.direction, this.onEnter, this.onLeave, this.onFail, depth);
    }

    public static enum FileWalkDirection {
        TOP_DOWN,
        BOTTOM_UP;

    }

    private class FileTreeWalkIterator
    extends AbstractIterator<File> {
        private Stack<WalkState> state = new Stack();

        FileTreeWalkIterator() {
            if (FileTreeWalk.this.start.isDirectory()) {
                this.state.push((Object)this.directoryState(FileTreeWalk.this.start));
            } else if (FileTreeWalk.this.start.isFile()) {
                this.state.push((Object)new SingleFileState(FileTreeWalk.this.start));
            } else {
                this.done();
            }
        }

        public void computeNext() {
            File nextFile = this.gotoNext();
            if (nextFile != null) {
                this.setNext(nextFile);
            } else {
                this.done();
            }
        }

        private DirectoryState directoryState(File root) {
            return FileTreeWalk.this.direction == FileWalkDirection.TOP_DOWN ? new TopDownDirectoryState(root) : new BottomUpDirectoryState(root);
        }

        private File gotoNext() {
            if (this.state.isEmpty()) {
                return null;
            }
            WalkState topState = (WalkState)this.state.peek();
            File file = topState.step();
            if (file == null) {
                this.state.pop();
                return this.gotoNext();
            }
            if (file == topState.root || !file.isDirectory() || this.state.size() >= FileTreeWalk.this.maxDepth) {
                return file;
            }
            this.state.push((Object)this.directoryState(file));
            return this.gotoNext();
        }

        private class SingleFileState
        extends WalkState {
            private boolean visited;

            SingleFileState(File root) {
                super(root);
            }

            @Override
            public File step() {
                if (this.visited) {
                    return null;
                }
                this.visited = true;
                return this.root;
            }
        }

        private class TopDownDirectoryState
        extends DirectoryState {
            private boolean rootVisited;
            private File[] fileList;
            private int fileIndex;

            TopDownDirectoryState(File rootDir) {
                super(rootDir);
            }

            @Override
            public File step() {
                if (!this.rootVisited) {
                    if (FileTreeWalk.this.onEnter != null && !((Boolean)FileTreeWalk.this.onEnter.apply(this.root)).booleanValue()) {
                        return null;
                    }
                    this.rootVisited = true;
                    return this.root;
                }
                if (this.fileList == null || this.fileIndex < this.fileList.length) {
                    if (this.fileList == null) {
                        this.fileList = this.root.listFiles();
                        if (this.fileList == null && FileTreeWalk.this.onFail != null) {
                            FileTreeWalk.this.onFail.accept(this.root, new AccessDeniedException(this.root.toString(), null, "Cannot list files in a directory"));
                        }
                        if (this.fileList == null || this.fileList.length == 0) {
                            if (FileTreeWalk.this.onLeave != null) {
                                FileTreeWalk.this.onLeave.accept(this.root);
                            }
                            return null;
                        }
                    }
                    return this.fileList[this.fileIndex++];
                }
                if (FileTreeWalk.this.onLeave != null) {
                    FileTreeWalk.this.onLeave.accept(this.root);
                }
                return null;
            }
        }

        private class BottomUpDirectoryState
        extends DirectoryState {
            private boolean rootVisited;
            private File[] fileList;
            private int fileIndex;
            private boolean failed;

            BottomUpDirectoryState(File rootDir) {
                super(rootDir);
            }

            @Override
            public File step() {
                if (!this.failed && this.fileList == null) {
                    if (FileTreeWalk.this.onEnter != null && !((Boolean)FileTreeWalk.this.onEnter.apply(this.root)).booleanValue()) {
                        return null;
                    }
                    this.fileList = this.root.listFiles();
                    if (this.fileList == null) {
                        if (FileTreeWalk.this.onFail != null) {
                            FileTreeWalk.this.onFail.accept(this.root, new AccessDeniedException(this.root.toString(), null, "Cannot list files in a directory"));
                        }
                        this.failed = true;
                    }
                }
                if (this.fileList != null && this.fileIndex < this.fileList.length) {
                    return this.fileList[this.fileIndex++];
                }
                if (!this.rootVisited) {
                    this.rootVisited = true;
                    return this.root;
                }
                if (FileTreeWalk.this.onLeave != null) {
                    FileTreeWalk.this.onLeave.accept(this.root);
                }
                return null;
            }
        }
    }

    private abstract class DirectoryState
    extends WalkState {
        private File rootDir;

        DirectoryState(File rootDir) {
            super(rootDir);
            this.rootDir = rootDir;
        }
    }

    private abstract class WalkState {
        final File root;

        WalkState(File root) {
            this.root = root;
        }

        public abstract File step();
    }
}

