/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.image;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcClass;
import manifold.api.host.IModule;
import manifold.api.image.ImageCodeGen;
import manifold.api.image.Model;
import manifold.api.type.JavaTypeManifold;

public class ImageTypeManifold
extends JavaTypeManifold<Model> {
    private static final Set<String> FILE_EXTENSIONS = new HashSet<String>(Arrays.asList("jpg", "png", "bmp", "wbmp", "gif"));

    public void init(IModule module) {
        this.init(module, (host, fqn) -> new Model(this.getModule().getHost(), (String)host, (Set<IFile>)fqn));
    }

    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    public String getTypeNameForFile(String fqn, IFile file) {
        if (!fqn.endsWith(file.getBaseName() + '_' + file.getExtension())) {
            fqn = fqn + '_' + file.getExtension();
        }
        return fqn;
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        return false;
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, boolean genStubs, String existing, Model model, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcClass = new ImageCodeGen(model._url, topLevelFqn).make();
        StringBuilder sb = srcClass.render(new StringBuilder(), 0);
        return sb.toString();
    }
}

