/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.highjump;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import manifold.api.highjump.Symbol;

public class Options {
    public final String expr;
    public final List<String> imports;
    public final List<String> staticImports;
    public final ClassLoader contextLoader;
    public final Map<String, Symbol> symbols;

    public static Builder builder(String expr) {
        return new Builder(expr);
    }

    private Options(String expr, List<String> imports, List<String> staticImports, ClassLoader contextLoader, Map<String, Symbol> symbols) {
        this.expr = expr;
        this.imports = imports;
        this.staticImports = staticImports;
        this.contextLoader = contextLoader;
        this.symbols = symbols;
    }

    public static class Builder {
        private final String _expr;
        private final List<String> _imports = new ArrayList<String>();
        private final List<String> _staticImports = new ArrayList<String>();
        private final Map<String, Symbol> _symbols = new ConcurrentHashMap<String, Symbol>();
        private ClassLoader _contextLoader;

        private Builder(String expr) {
            this._expr = expr;
        }

        public Builder importClass(Class clazz) {
            this._imports.add(clazz.getTypeName());
            return this;
        }

        public Builder importStatic(Class clazz, String member) {
            this._staticImports.add(clazz.getTypeName() + '.' + member);
            return this;
        }

        public Builder contextLoader(ClassLoader contextLoader) {
            this._contextLoader = contextLoader;
            return this;
        }

        public Builder symbol(String name, Symbol type) {
            this._symbols.put(name, type);
            return this;
        }

        public Builder symbols(Map<String, Symbol> symbols) {
            this._symbols.putAll(symbols);
            return this;
        }

        public Options build() {
            return new Options(this._expr, this._imports, this._staticImports, this._contextLoader, this._symbols);
        }
    }
}

