/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.highjump;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.highjump.ExpressionClass;
import manifold.api.highjump.Options;
import manifold.api.highjump.Symbol;
import manifold.api.host.IModule;
import manifold.api.host.RefreshKind;
import manifold.api.service.BaseService;
import manifold.api.type.ClassType;
import manifold.api.type.ContributorKind;
import manifold.api.type.ISourceKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.api.util.fingerprint.Fingerprint;

public class HighjumpTypeManifold
extends BaseService
implements ITypeManifold {
    private static final String PKG = "manifold.highjump.pkg";
    private static final String PREFIX = "HjClass_";
    static final String FQN_PREFIX = "manifold.highjump.pkg.HjClass_";
    private static final String SYMBOL = "_Symbol_";
    private static final String FQN_SYMBOL_PREFIX = "manifold.highjump.pkg.HjClass__Symbol_";
    private IModule _module;
    private final Map<ClassLoader, Map<Fingerprint, ExpressionClass>> _fpToExprClass = new ConcurrentHashMap<ClassLoader, Map<Fingerprint, ExpressionClass>>();
    private final Map<String, ExpressionClass> _fqnToExprClass = new ConcurrentHashMap<String, ExpressionClass>();
    private final Map<String, Symbol> _fqnToSymbol = new ConcurrentHashMap<String, Symbol>();

    public void init(IModule module) {
        this._module = module;
    }

    public IModule getModule() {
        return this._module;
    }

    public ISourceKind getSourceKind() {
        return ISourceKind.Java;
    }

    public ContributorKind getContributorKind() {
        return ContributorKind.Primary;
    }

    public boolean isTopLevelType(String fqn) {
        return this.isType(fqn);
    }

    public ClassType getClassType(String fqn) {
        return ClassType.JavaClass;
    }

    public List<IFile> findFilesForType(String fqn) {
        return Collections.emptyList();
    }

    public void clear() {
    }

    public Object evaluate(Options options) {
        Map loaderToExprCache = this._fpToExprClass.computeIfAbsent(options.contextLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : options.contextLoader, key -> new ConcurrentHashMap());
        ExpressionClass exprClass = loaderToExprCache.computeIfAbsent(new Fingerprint(options.expr), key -> new ExpressionClass(options, this._fqnToExprClass));
        return exprClass.evaluate();
    }

    public boolean isType(String fqn) {
        return fqn.startsWith(FQN_PREFIX);
    }

    public boolean isPackage(String pkg) {
        return pkg.equals(PKG);
    }

    public String getPackage(String fqn) {
        return this.isType(fqn) ? PKG : null;
    }

    public String contribute(JavaFileManager.Location location, String fqn, String existing, DiagnosticListener<JavaFileObject> errorHandler) {
        if (fqn.startsWith(FQN_SYMBOL_PREFIX)) {
            return this.makeSymbolClass(fqn, errorHandler);
        }
        ExpressionClass exprClass = this._fqnToExprClass.get(fqn);
        SrcClass srcClass = new SrcClass(fqn, AbstractSrcClass.Kind.Class);
        for (String string : exprClass.getOptions().imports) {
            srcClass.addImport(string);
        }
        for (String string : exprClass.getOptions().staticImports) {
            srcClass.addStaticImport(string);
        }
        for (Map.Entry entry : exprClass.getOptions().symbols.entrySet()) {
            Symbol symbol = (Symbol)entry.getValue();
            String symClassName = symbol.getUid() + '$' + symbol.getName();
            String symFqn = FQN_SYMBOL_PREFIX + symClassName;
            this._fqnToSymbol.put(symFqn, symbol);
            srcClass.addStaticImport(symFqn + '.' + symbol.getName());
        }
        srcClass.addMethod(((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("evaluate")).modifiers(1L)).returns(Object.class)).body("return " + exprClass.getOptions().expr + ';'));
        return srcClass.toString();
    }

    private String makeSymbolClass(String fqn, DiagnosticListener<JavaFileObject> errorHandler) {
        Symbol symbol = this._fqnToSymbol.get(fqn);
        SrcClass srcClass = new SrcClass(fqn, AbstractSrcClass.Kind.Class);
        srcClass.modifiers(17L);
        SrcField field = (SrcField)new SrcField(symbol.getName(), symbol.getType()).modifiers(9L);
        if (symbol.getInitialValue() != null) {
            // empty if block
        }
        srcClass.addField(field);
        return null;
    }

    public Collection<String> getAllTypeNames() {
        return Collections.emptyList();
    }

    public Collection<TypeName> getTypeNames(String namespace) {
        return Collections.emptyList();
    }

    public boolean handlesFileExtension(String fileExtension) {
        return false;
    }

    public boolean handlesFile(IFile file) {
        return false;
    }

    public String[] getTypesForFile(IFile file) {
        return new String[0];
    }

    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        return null;
    }
}

