/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.language.Definition;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.TypeDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.type.JavaTypeManifold;
import manifold.graphql.type.GqlModel;
import manifold.graphql.type.GqlParentType;
import manifold.graphql.type.GqlScopeFinder;

public class GqlManifold
extends JavaTypeManifold<GqlModel> {
    public static final List<String> EXTS = Arrays.asList("graphql", "graphqls", "gql");
    private GqlScopeFinder _scopeFinder;

    public void init(IModule module) {
        this._scopeFinder = new GqlScopeFinder(this);
        this.init(module, (fqn, files) -> new GqlModel(this, (String)fqn, (Set<IFile>)files));
    }

    public GqlScopeFinder getScopeFinder() {
        return this._scopeFinder;
    }

    public boolean handlesFileExtension(String fileExtension) {
        return EXTS.contains(fileExtension);
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        GqlParentType type;
        GqlModel model = (GqlModel)this.getModel(topLevel);
        GqlParentType gqlParentType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        Definition typeDef = null;
        StringTokenizer tokenizer = new StringTokenizer(relativeInner, ".");
        while (tokenizer.hasMoreTokens()) {
            String innerName = tokenizer.nextToken();
            if ((typeDef = typeDef == null ? type.getChild(innerName) : this.getChildDefinition(typeDef, innerName)) != null) continue;
            return innerName.equals("Builder") && !tokenizer.hasMoreTokens();
        }
        return typeDef != null;
    }

    private Definition getChildDefinition(Definition def, String name) {
        for (Node child : def.getNamedChildren().getChildren(name)) {
            if (!(child instanceof TypeDefinition) && !(child instanceof OperationDefinition)) continue;
            return (Definition)child;
        }
        return null;
    }

    public <R> R findByModel(Function<GqlModel, R> byModel) {
        return this.getAllTypeNames().stream().map(fqn -> {
            GqlModel model = (GqlModel)this.getModel((String)fqn);
            return model == null ? null : byModel.apply(model);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <R> Stream<R> findAllByModel(Function<GqlModel, R> byModel) {
        return this.getAllTypeNames().stream().map(fqn -> {
            GqlModel model = (GqlModel)this.getModel((String)fqn);
            return model == null ? null : byModel.apply(model);
        }).filter(Objects::nonNull);
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, boolean genStubs, String existing, GqlModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        if (!model.getScope().hasConfigErrors()) {
            model.getType().render(sb, location, this.getModule(), errorHandler);
        }
        model.report(errorHandler);
        return sb.toString();
    }
}

