/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.request;

import java.util.List;
import javax.script.Bindings;
import manifold.api.json.Endpoint;
import manifold.api.json.Requester;
import manifold.ext.RuntimeMethods;
import manifold.graphql.request.GqlRequestBody;
import manifold.graphql.request.GqlRequestException;

public class Executor<T> {
    private final GqlRequestBody _reqArgs;
    private Requester<Bindings> _requester;

    public Executor(String url, String operation, String query, Bindings variables) {
        this._requester = new Requester(url);
        this._requester.withHeader("Content-Type", "application/json");
        this._reqArgs = GqlRequestBody.create(query, variables);
    }

    public Executor(Endpoint endpoint, String operation, String query, Bindings variables) {
        this._requester = new Requester(endpoint);
        this._requester.withHeader("Content-Type", "application/json");
        this._reqArgs = GqlRequestBody.create(query, variables);
    }

    public Executor<T> withHeader(String name, String value) {
        this._requester.withHeader(name, value);
        return this;
    }

    public Executor<T> withParam(String name, String value) {
        this._requester.withParam(name, value);
        return this;
    }

    public Executor<T> withBasicAuthorization(String username, String password) {
        this._requester.withBasicAuthorization(username, password);
        return this;
    }

    public Executor<T> withBearerAuthorization(String accessToken) {
        return this.withAuthorization("Bearer", accessToken);
    }

    public Executor<T> withAuthorization(String tokenType, String accessToken) {
        return this.withHeader("Authorization", tokenType + " " + accessToken);
    }

    public Executor<T> withTimeout(int timeout) {
        this._requester.withTimeout(timeout);
        return this;
    }

    public T post() throws GqlRequestException {
        Bindings response = (Bindings)this._requester.postOne((Object)((GqlRequestBody)RuntimeMethods.constructProxy((Object)this._reqArgs, GqlRequestBody.class)).getBindings());
        this.handleErrors(response);
        return (T)response.get("data");
    }

    public T post(Requester.Format format) throws GqlRequestException {
        Bindings response = (Bindings)this._requester.postOne("", (Object)((GqlRequestBody)RuntimeMethods.constructProxy((Object)this._reqArgs, GqlRequestBody.class)).getBindings(), format);
        this.handleErrors(response);
        return (T)response.get("data");
    }

    public T get() throws GqlRequestException {
        Bindings response = (Bindings)this._requester.getOne((Object)((GqlRequestBody)RuntimeMethods.constructProxy((Object)this._reqArgs, GqlRequestBody.class)).getBindings());
        this.handleErrors(response);
        return (T)response.get("data");
    }

    public T get(Requester.Format format) throws GqlRequestException {
        Bindings response = (Bindings)this._requester.getOne("", (Object)((GqlRequestBody)RuntimeMethods.constructProxy((Object)this._reqArgs, GqlRequestBody.class)).getBindings(), format);
        this.handleErrors(response);
        return (T)response.get("data");
    }

    private void handleErrors(Bindings response) {
        List errors = (List)response.get("errors");
        if (errors != null) {
            throw new GqlRequestException(errors);
        }
    }
}

