/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Collection;
import java.util.HashSet;
import manifold.api.json.schema.FormatTypeResolvers;
import manifold.api.json.schema.IJsonFormatTypeResolver;
import manifold.api.json.schema.JsonFormatType;
import manifold.util.ManStringUtil;

public class GqlScalars {
    public static Collection<GraphQLScalarType> transformFormatTypeResolvers() {
        HashSet<GraphQLScalarType> scalars = new HashSet<GraphQLScalarType>();
        for (IJsonFormatTypeResolver resolver : FormatTypeResolvers.get()) {
            resolver.getFormats().forEach(format -> {
                JsonFormatType jsonFormatType = resolver.resolveType(format);
                scalars.add(GraphQLScalarType.newScalar().name(ManStringUtil.toPascalCase((String)format)).description("Support values of type: " + jsonFormatType.getJavaType().getTypeName()).coercing(GqlScalars.makeCoercer(jsonFormatType, resolver)).build());
            });
        }
        return scalars;
    }

    private static Coercing makeCoercer(final JsonFormatType jsonFormatType, final IJsonFormatTypeResolver resolver) {
        return new Coercing(){

            public Object parseValue(Object input) throws CoercingParseValueException {
                try {
                    return resolver.coerce(input, jsonFormatType.getJavaType());
                }
                catch (Exception e) {
                    throw new CoercingParseValueException((Throwable)e);
                }
            }

            public Object serialize(Object dataFetcherResult) throws CoercingSerializeException {
                return dataFetcherResult;
            }

            public Object parseLiteral(Object input) throws CoercingParseLiteralException {
                if (input instanceof StringValue && !((StringValue)input).isEqualTo(null)) {
                    return this.parseValue(((StringValue)input).getValue());
                }
                throw new CoercingParseLiteralException("Empty 'StringValue' provided.");
            }
        };
    }
}

