/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.type.JavaTypeManifold;
import manifold.graphql.type.GqlModel;
import manifold.graphql.type.GqlParentType;

public class GqlManifold
extends JavaTypeManifold<GqlModel> {
    public static final List<String> EXTS = Arrays.asList("graphql", "graphqls", "gql");

    public void init(IModule module) {
        this.init(module, (fqn, files) -> new GqlModel(this, (String)fqn, (Set<IFile>)files));
    }

    public boolean handlesFileExtension(String fileExtension) {
        return EXTS.contains(fileExtension);
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        GqlParentType type;
        GqlModel model = (GqlModel)this.getModel(topLevel);
        GqlParentType gqlParentType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        return type.hasChild(relativeInner);
    }

    TypeDefinition findTypeDefinition(String simpleName) {
        return this.getAllTypeNames().stream().map(fqn -> ((GqlModel)this.getModel((String)fqn)).getTypeDefinition(simpleName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    ScalarTypeDefinition findScalarTypeDefinition(String simpleName) {
        return this.getAllTypeNames().stream().map(fqn -> ((GqlModel)this.getModel((String)fqn)).getScalarTypeDefinition(simpleName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    SchemaDefinition findSchemaDefinition() {
        return this.getAllTypeNames().stream().map(fqn -> ((GqlModel)this.getModel((String)fqn)).getSchemaDefinition()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, String existing, GqlModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        model.report(errorHandler);
        model.getType().render(sb);
        return sb.toString();
    }
}

